/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;

public class DeleteCloudFolderHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ArrayList<SeawindFolder> folders = new ArrayList<SeawindFolder>();
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof SeawindFolder)) continue;
                folders.add((SeawindFolder)element);
            }
            if (!folders.isEmpty()) {
                this.deleteCloudFolder(folders, shell);
            }
        }
        return null;
    }

    private void deleteCloudFolder(List<SeawindFolder> folders, Shell shell) {
        String title = SeawindMessages.DeleteCloudFolderHandler_Dialog_Title;
        String message = folders.size() > 1 ? SeawindMessages.DeleteCloudFolderHandler_Delete_Batch_Message : NLS.bind((String)SeawindMessages.DeleteCloudFolderHandler_Delete_One_Message, (Object)folders.get(0).getTitle());
        MessageDialog confirmDialog = new MessageDialog(shell, title, null, message, 5, new String[]{SeawindMessages.DeleteCloudFolderHandler_Button_Delete, IDialogConstants.CANCEL_LABEL}, 0);
        if (confirmDialog.open() != 0) {
            return;
        }
        for (SeawindFolder folder : folders) {
            SeawindUIPlugin.getSeawindLibrary().removeFolder(folder);
        }
    }
}

