/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.draw2d.PathFigure;

public class SelectionFigure
extends PathFigure
implements IUseTransparency {
    private static final int FLAG_SELECTED = MAX_FLAG << 1;
    private static final int FLAG_PRESELECTED = MAX_FLAG << 2;
    private static final int FLAG_FOCUSED;
    private Color focusColor = ColorConstants.darkBlue;
    private Color selectionColor = ColorConstants.blue;
    private Color preselectionColor = ColorConstants.lightGray;
    private Color focusFillColor = null;
    private Color selectionFillColor = null;
    private Color preselectionFillColor = null;
    private int focusAlpha = 224;
    private int selectionAlpha = 192;
    private int preselectionAlpha = 128;
    private int focusFillAlpha = 0;
    private int selectionFillAlpha = 0;
    private int preselectionFillAlpha = 56;
    private int outlineAlpha = 255;
    private int fillAlpha = 0;

    static {
        MAX_FLAG = FLAG_FOCUSED = MAX_FLAG << 3;
    }

    public SelectionFigure() {
        this.setLineStyle(1);
        this.update();
    }

    public boolean isSelected() {
        return this.getFlag(FLAG_SELECTED);
    }

    public boolean isPreselected() {
        return this.getFlag(FLAG_PRESELECTED);
    }

    public boolean isFocused() {
        return this.getFlag(FLAG_FOCUSED);
    }

    public void setSelected(boolean selected) {
        boolean currentSelection = this.isSelected();
        if (selected == currentSelection) {
            return;
        }
        this.setFlag(FLAG_SELECTED, selected);
        this.update();
    }

    public void setPreselected(boolean preselected) {
        boolean currentPreselection = this.isPreselected();
        if (preselected == currentPreselection) {
            return;
        }
        this.setFlag(FLAG_PRESELECTED, preselected);
        this.update();
    }

    public void setFocused(boolean focused) {
        boolean currentFocused = this.isFocused();
        if (focused == currentFocused) {
            return;
        }
        this.setFlag(FLAG_FOCUSED, focused);
        this.update();
    }

    private void update() {
        this.updateColors(this.getOutlineColor(), this.getFillColor());
        this.setMainAlpha(this.getFillAlpha());
        this.setSubAlpha(this.getOutlineAlpha());
    }

    private void updateColors(Color outlineColor, Color fillColor) {
        this.setOutline(outlineColor != null);
        this.setForegroundColor(outlineColor);
        this.setFill(fillColor != null);
        this.setBackgroundColor(fillColor);
    }

    private Color getOutlineColor() {
        if (this.isFocused()) {
            return this.getFocusColor();
        }
        if (this.isSelected()) {
            return this.getSelectionColor();
        }
        if (this.isPreselected()) {
            return this.getPreselectionColor();
        }
        return null;
    }

    private Color getFillColor() {
        if (this.isFocused()) {
            return this.getFocusFillColor();
        }
        if (this.isSelected()) {
            return this.getSelectionFillColor();
        }
        if (this.isPreselected()) {
            return this.getPreselectionFillColor();
        }
        return null;
    }

    private int getOutlineAlpha() {
        if (this.isFocused()) {
            return this.getFocusAlpha();
        }
        if (this.isSelected()) {
            return this.getSelectionAlpha();
        }
        if (this.isPreselected()) {
            return this.getPreselectionAlpha();
        }
        return 255;
    }

    private int getFillAlpha() {
        if (this.isFocused()) {
            return this.getFocusFillAlpha();
        }
        if (this.isSelected()) {
            return this.getSelectionFillAlpha();
        }
        if (this.isPreselected()) {
            return this.getPreselectionFillAlpha();
        }
        return 0;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public Color getPreselectionColor() {
        return this.preselectionColor;
    }

    public Color getFocusFillColor() {
        return this.focusFillColor;
    }

    public Color getSelectionFillColor() {
        return this.selectionFillColor;
    }

    public Color getPreselectionFillColor() {
        return this.preselectionFillColor;
    }

    public int getFocusAlpha() {
        return this.focusAlpha;
    }

    public int getSelectionAlpha() {
        return this.selectionAlpha;
    }

    public int getPreselectionAlpha() {
        return this.preselectionAlpha;
    }

    public int getFocusFillAlpha() {
        return this.focusFillAlpha;
    }

    public int getSelectionFillAlpha() {
        return this.selectionFillAlpha;
    }

    public int getPreselectionFillAlpha() {
        return this.preselectionFillAlpha;
    }

    public void setSelectionColor(Color selectionColor) {
        if (SelectionFigure.equals(selectionColor, this.selectionColor)) {
            return;
        }
        this.selectionColor = selectionColor;
        this.update();
    }

    public void setFocusColor(Color focusColor) {
        if (SelectionFigure.equals(focusColor, this.focusColor)) {
            return;
        }
        this.focusColor = focusColor;
        this.update();
    }

    public void setPreselectionColor(Color preselectionColor) {
        if (SelectionFigure.equals(preselectionColor, this.preselectionColor)) {
            return;
        }
        this.preselectionColor = preselectionColor;
        this.update();
    }

    public void setSelectionFillColor(Color selectionFillColor) {
        if (SelectionFigure.equals(selectionFillColor, this.selectionFillColor)) {
            return;
        }
        this.selectionFillColor = selectionFillColor;
        this.update();
    }

    public void setFocusFillColor(Color focusFillColor) {
        if (SelectionFigure.equals(focusFillColor, this.focusFillColor)) {
            return;
        }
        this.focusFillColor = focusFillColor;
        this.update();
    }

    public void setPreselectionFillColor(Color preselectionFillColor) {
        if (SelectionFigure.equals(preselectionFillColor, this.preselectionFillColor)) {
            return;
        }
        this.preselectionFillColor = preselectionFillColor;
        this.update();
    }

    public void setFocusAlpha(int focusAlpha) {
        if (focusAlpha == this.getFocusAlpha()) {
            return;
        }
        this.focusAlpha = focusAlpha;
        this.update();
    }

    public void setSelectionAlpha(int selectionAlpha) {
        if (selectionAlpha == this.getSelectionAlpha()) {
            return;
        }
        this.selectionAlpha = selectionAlpha;
        this.update();
    }

    public void setPreselectionAlpha(int preselectionAlpha) {
        if (preselectionAlpha == this.getPreselectionAlpha()) {
            return;
        }
        this.preselectionAlpha = preselectionAlpha;
        this.update();
    }

    public void setFocusFillAlpha(int focusFillAlpha) {
        if (focusFillAlpha == this.getFocusFillAlpha()) {
            return;
        }
        this.focusFillAlpha = focusFillAlpha;
        this.update();
    }

    public void setSelectionFillAlpha(int selectionFillAlpha) {
        if (selectionFillAlpha == this.getSelectionFillAlpha()) {
            return;
        }
        this.selectionFillAlpha = selectionFillAlpha;
        this.update();
    }

    public void setPreselectionFillAlpha(int preselectionFillAlpha) {
        if (preselectionFillAlpha == this.getPreselectionFillAlpha()) {
            return;
        }
        this.preselectionFillAlpha = preselectionFillAlpha;
        this.update();
    }

    public int getMainAlpha() {
        return this.fillAlpha;
    }

    public int getSubAlpha() {
        return this.outlineAlpha;
    }

    public void setMainAlpha(int alpha) {
        if (alpha == this.getMainAlpha()) {
            return;
        }
        this.fillAlpha = alpha;
        this.repaint();
    }

    public void setSubAlpha(int alpha) {
        if (alpha == this.getSubAlpha()) {
            return;
        }
        this.outlineAlpha = alpha;
        this.repaint();
    }

    protected void fillShape(Graphics graphics) {
        graphics.setAlpha(this.getMainAlpha());
        super.fillShape(graphics);
    }

    protected void outlineShape(Graphics graphics) {
        int alpha = this.getSubAlpha();
        graphics.setAlpha(Math.max(0, alpha));
        super.outlineShape(graphics);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

