/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.io.ResourceMapping;
import org.xmind.core.io.ResourceMappingManager;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroup {
    private Element implementation;
    private ResourceMappingManager manager;
    private List<ResourceMapping> items;
    private Map<String, String> srcToDest;
    private Map<String, String> destToSrc;

    protected ResourceGroup(Element implementation, ResourceMappingManager manager) {
        this.implementation = implementation;
        this.manager = manager;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public ResourceMappingManager getManager() {
        return this.manager;
    }

    public String getApplicationId() {
        return this.manager.getApplicationId();
    }

    public String getDestination(String source) {
        this.ensureLoaded();
        return this.srcToDest.get(source);
    }

    public String getSource(String destination) {
        this.ensureLoaded();
        return this.destToSrc.get(destination);
    }

    public String getType() {
        return DOMUtils.getAttribute((Element)this.implementation, (String)"type");
    }

    public List<ResourceMapping> getItems() {
        this.ensureLoaded();
        return this.items;
    }

    private void ensureLoaded() {
        if (this.items != null && this.srcToDest != null && this.destToSrc != null) {
            return;
        }
        this.lazyLoad();
        if (this.items == null) {
            this.items = Collections.emptyList();
        }
        if (this.srcToDest == null) {
            this.srcToDest = Collections.emptyMap();
        }
        if (this.destToSrc == null) {
            this.destToSrc = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        Iterator it = DOMUtils.childElementIterByTag((Node)this.implementation, (String)"resource-mapping");
        while (it.hasNext()) {
            this.createTransferItem((Element)it.next());
        }
    }

    private void createTransferItem(Element element) {
        ResourceMapping item = new ResourceMapping(element, this);
        if (this.items == null) {
            this.items = new ArrayList<ResourceMapping>();
        }
        this.items.add(item);
        String src = item.getSource();
        String dest = item.getDestination();
        if (src != null) {
            if (this.srcToDest == null) {
                this.srcToDest = new HashMap<String, String>();
            }
            this.srcToDest.put(src, dest);
        }
        if (dest != null) {
            if (this.destToSrc == null) {
                this.destToSrc = new HashMap<String, String>();
            }
            this.destToSrc.put(dest, src);
        }
    }
}

