/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command.remote.lan.dnssd;

import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.IReturnValueConsumer;
import org.xmind.core.command.remote.ICommandServiceInfo;
import org.xmind.core.command.remote.IIdentifier;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.command.remote.Identifier;
import org.xmind.core.command.remote.Options;
import org.xmind.core.command.remote.socket.ISocketAddress;
import org.xmind.core.command.remote.socket.OutgoingSocketCommandHandler;
import org.xmind.core.command.remote.socket.SocketAddress;
import org.xmind.core.command.remote.socket.SocketCommandServiceInfo;
import org.xmind.core.command.remote.socket.SocketPool;
import org.xmind.core.internal.command.remote.lan.Messages;
import org.xmind.core.internal.command.remote.lan.Util;
import org.xmind.core.internal.command.remote.lan.dnssd.ResolveAdapter;

public class DNSSDRemoteCommandService
extends ResolveAdapter
implements IRemoteCommandService {
    private final String domainId;
    private final SocketCommandServiceInfo info;
    private boolean resolving = false;
    private SocketPool socketPool = null;

    public DNSSDRemoteCommandService(int flags, int ifIndex, String serviceName, String regType, String domain, String hostName, int port, TXTRecord txtRecord, String domainId) {
        super(flags, ifIndex, serviceName, regType, domain);
        this.domainId = domainId;
        this.info = new SocketCommandServiceInfo();
        this.fillCommandServiceInfo(hostName, port, txtRecord);
    }

    public void setSocketPool(SocketPool socketPool) {
        this.socketPool = socketPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, ICommand command, IReturnValueConsumer returnValueConsumer, Options options) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.DNSSDRemoteCommandService_ResolveRemoteCommandService);
        doResolve = false;
        var6_6 = this.info;
        synchronized (var6_6) {
            if (!this.resolving) {
                this.resolving = true;
                doResolve = true;
            }
        }
        resolver = null;
        if (!doResolve) ** GOTO lbl25
        try {
            resolver = DNSSD.resolve((int)this.flags, (int)this.ifIndex, (String)this.serviceName, (String)this.regType, (String)this.domain, (ResolveListener)this);
            if (true) ** GOTO lbl25
        }
        catch (DNSSDException e) {
            return new Status(4, "org.xmind.core.command.remote.lan", Messages.DNSSDRemoteCommandService_FailedResolveRemoteCommand, (Throwable)e);
        }
        {
            while (true) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Thread.sleep(0L);
lbl25:
                // 3 sources

                if (this.resolving) continue;
                break;
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(10);
        monitor.subTask(Messages.DNSSDRemoteCommandService_SendCommand);
        handleMonitor = new SubProgressMonitor(monitor, 90);
        handler = new OutgoingSocketCommandHandler(this.info.getAddress());
        handler.setPluginId("org.xmind.core.command.remote.lan");
        handler.setSocketPool(this.socketPool);
        handled = handler.handleOutgoingCommand((IProgressMonitor)handleMonitor, command, returnValueConsumer, options.timeout());
        if (handleMonitor.isCanceled() != false) return handled;
        handleMonitor.done();
        return handled;
        catch (InterruptedException v1) {
            return Status.CANCEL_STATUS;
        }
    }

    public ICommandServiceInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(DNSSDService resolver, int flags, int ifIndex, String fullName, String hostName, int port, TXTRecord txtRecord) {
        this.fillCommandServiceInfo(hostName, port, txtRecord);
        SocketCommandServiceInfo socketCommandServiceInfo = this.info;
        synchronized (socketCommandServiceInfo) {
            this.resolving = false;
        }
    }

    private void fillCommandServiceInfo(String hostName, int port, TXTRecord txtRecord) {
        this.info.setId((IIdentifier)new Identifier(this.domainId, this.serviceName));
        this.info.setAddress((ISocketAddress)new SocketAddress(hostName, port));
        byte[] nameBytes = txtRecord.getValue("name");
        if (nameBytes != null) {
            this.info.setName(Util.decode(nameBytes));
        }
        DNSSDRemoteCommandService.restoreMetadata(this.info, txtRecord, "ver");
        DNSSDRemoteCommandService.restoreMetadata(this.info, txtRecord, "cli");
        DNSSDRemoteCommandService.restoreMetadata(this.info, txtRecord, "cliid");
        DNSSDRemoteCommandService.restoreMetadata(this.info, txtRecord, "cliver");
        DNSSDRemoteCommandService.restoreMetadata(this.info, txtRecord, "clibid");
    }

    private static void restoreMetadata(SocketCommandServiceInfo info, TXTRecord txtRecord, String key) {
        byte[] bytes = txtRecord.getValue(key);
        info.setMetadata(key, bytes == null ? null : Util.decode(bytes));
    }
}

