/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.io;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.internal.ToolkitPlugin;

public class UIJobChangeListener
implements IJobChangeListener {
    private Display display;
    private boolean syncExecute;

    public UIJobChangeListener() {
        this(false);
    }

    public UIJobChangeListener(boolean syncExecute) {
        this(Display.getCurrent(), syncExecute);
    }

    public UIJobChangeListener(Display display) {
        this(display, false);
    }

    public UIJobChangeListener(Display display, boolean syncExecute) {
        this.display = display;
        this.syncExecute = syncExecute;
    }

    protected boolean isSyncExecute() {
        return this.syncExecute;
    }

    protected Display getDisplay() {
        return this.display;
    }

    private void runInUIThread(final Runnable runnable) {
        if (this.display != null && !this.display.isDisposed()) {
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            runnable.run();
                        }
                    });
                }
            };
            if (this.isSyncExecute()) {
                this.display.syncExec(runnable2);
            } else {
                this.display.asyncExec(runnable2);
            }
        } else {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                ToolkitPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.toolkit", "Error occurred when running in UI thread.", e));
            }
        }
    }

    public final void aboutToRun(final IJobChangeEvent event) {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                UIJobChangeListener.this.doAboutToRun(event);
            }
        });
    }

    public final void awake(final IJobChangeEvent event) {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                UIJobChangeListener.this.doAwake(event);
            }
        });
    }

    public final void done(final IJobChangeEvent event) {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                UIJobChangeListener.this.doDone(event);
            }
        });
    }

    public final void running(final IJobChangeEvent event) {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                UIJobChangeListener.this.doRunning(event);
            }
        });
    }

    public final void scheduled(final IJobChangeEvent event) {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                UIJobChangeListener.this.doScheduled(event);
            }
        });
    }

    public final void sleeping(final IJobChangeEvent event) {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                UIJobChangeListener.this.doSleeping(event);
            }
        });
    }

    protected void doAboutToRun(IJobChangeEvent event) {
    }

    protected void doAwake(IJobChangeEvent event) {
    }

    protected void doDone(IJobChangeEvent event) {
    }

    protected void doRunning(IJobChangeEvent event) {
    }

    protected void doScheduled(IJobChangeEvent event) {
    }

    protected void doSleeping(IJobChangeEvent event) {
    }
}

