/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.wizards.ISaveContext;
import org.xmind.ui.wizards.ISaveWizard;
import org.xmind.ui.wizards.SaveOptions;

public class LocalFileSaveWizard
implements ISaveWizard {
    public static final String ID = "org.xmind.ui.saveWizards.localFile";

    @Override
    public URI askForTargetURI(ISaveContext context, SaveOptions options) {
        Shell parentShell;
        String result;
        String proposalName = options.proposalName();
        URI oldURI = options.oldURI();
        ArrayList<Shell> cursorHiddenShells = new ArrayList<Shell>();
        Display display = Display.getCurrent();
        Shell[] shells = display.getShells();
        Cursor busyCursor = display.getSystemCursor(1);
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            Cursor cursor = shell.getCursor();
            if (cursor != null && cursor.equals((Object)busyCursor)) {
                shell.setCursor(null);
                cursorHiddenShells.add(shell);
            }
            ++n2;
        }
        String filterExtension = ".xmind";
        String extensionFullName = "*" + filterExtension;
        String filterFullName = "macosx".equals(Platform.getOS()) ? NLS.bind((String)"{0} ({1})", (Object)DialogMessages.WorkbookFilterName, (Object)extensionFullName) : DialogMessages.WorkbookFilterName;
        String dirPath = null;
        if (oldURI != null && "file".equals(oldURI.getScheme())) {
            dirPath = new File(oldURI).getParent();
        }
        if ((result = DialogUtils.save(parentShell = display.getActiveShell() != null ? display.getActiveShell() : new Shell(), proposalName, new String[]{extensionFullName}, new String[]{filterFullName}, 0, dirPath)) == null) {
            return null;
        }
        if ("win32".equals(SWT.getPlatform()) && !result.endsWith(filterExtension)) {
            result = String.valueOf(result) + filterExtension;
        }
        return new File(result).toURI();
    }

    @Override
    public int getPriorityFor(ISaveContext context, SaveOptions options) {
        return 50;
    }
}

