/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import javax.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.core.ITopic;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.e4models.ModelPage;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.MindMapUtils;

public class LocalImageModelPage
extends ModelPage
implements ISelectionChangedListener,
IPartListener {
    public static final String PAGE_ID = "org.xmind.ui.modelPart.image.pages.local";
    @Inject
    private IWorkbenchWindow workbenchWindow;
    private ResourceManager resources;
    private Button button;
    private IGraphicalEditor editor;

    public String getModelPageId() {
        return PAGE_ID;
    }

    public String getModelPageTitle() {
        return MindMapMessages.LocalImageModelPage_title;
    }

    protected Control doCreateControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)container);
        container.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        this.createContent(container);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LocalImageModelPage.this.dispose();
            }
        });
        return container;
    }

    private void createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 60;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createImageSection(composite);
        this.createButtonSection(composite);
    }

    private void createImageSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Label image = new Label(composite, 0);
        image.setBackground(composite.getBackground());
        image.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        image.setImage((Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().get("insert_local_image_page.png", true)));
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(parent.getBackground());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 10;
        layout2.marginHeight = 0;
        composite2.setLayout((Layout)layout2);
        Label text = new Label(composite2, 64);
        text.setBackground(composite2.getBackground());
        text.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        text.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#aaaaaa"))));
        text.setAlignment(0x1000000);
        text.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])text.getFont().getFontData(), (int)2))));
        text.setText(MindMapMessages.LocalImageModelPage_ImageSection_description);
    }

    private void createButtonSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.button = new Button(composite, 8);
        this.button.setBackground(composite.getBackground());
        GridData layoutData = new GridData(0x1000000, 0x1000000, true, false);
        layoutData.widthHint = 90;
        this.button.setLayoutData((Object)layoutData);
        this.button.setText(MindMapMessages.LocalImageModelPage_Insert_button);
        final InsertImageAction insertImageAction = new InsertImageAction();
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                insertImageAction.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setTargetEditor(this.getEditor());
        this.workbenchWindow.getActivePage().addPartListener((IPartListener)this);
    }

    public void setFocus() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setFocus();
        }
    }

    private void setTargetEditor(IGraphicalEditor editor) {
        if (editor == this.editor) {
            return;
        }
        if (this.editor != null) {
            this.editor.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.editor = editor;
        if (this.editor != null) {
            this.editor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            this.setSelection(editor.getSite().getSelectionProvider().getSelection());
        } else {
            this.setSelection(null);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    private void setSelection(ISelection selection) {
        boolean isEnabled = MindMapUtils.isSingleTopic(selection);
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(isEnabled);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IGraphicalEditor) {
            this.setTargetEditor((IGraphicalEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.setTargetEditor(null);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private void dispose() {
        this.setTargetEditor(null);
        this.workbenchWindow.getActivePage().removePartListener((IPartListener)this);
    }

    private IGraphicalEditor getEditor() {
        IEditorPart activeEditor = this.workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor) {
            return (IGraphicalEditor)activeEditor;
        }
        return null;
    }

    private class InsertImageAction
    extends Action {
        private InsertImageAction() {
        }

        public void run() {
            IGraphicalEditorPage page;
            IGraphicalEditorPage iGraphicalEditorPage = page = LocalImageModelPage.this.getEditor() == null ? null : LocalImageModelPage.this.getEditor().getActivePageInstance();
            if (page == null || page.isDisposed()) {
                return;
            }
            EditDomain domain = page.getEditDomain();
            if (domain == null) {
                return;
            }
            IGraphicalViewer viewer = page.getViewer();
            if (viewer == null) {
                return;
            }
            Control control = viewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            ISelection selection = viewer.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            Object o = ((IStructuredSelection)selection).getFirstElement();
            IPart part = viewer.findPart(o);
            ITopic topic = (ITopic)part.getAdapter(ITopic.class);
            if (topic == null) {
                return;
            }
            IPart topicPart = viewer.findPart((Object)topic);
            if (topicPart == null) {
                return;
            }
            FileDialog dialog = new FileDialog(control.getShell(), 4096);
            DialogUtils.makeDefaultImageSelectorDialog(dialog, true);
            dialog.setText(DialogMessages.SelectImageDialog_title);
            String path = dialog.open();
            if (path == null) {
                return;
            }
            this.insertImage(path, topicPart, (IViewer)viewer, domain);
        }

        private void insertImage(String path, IPart topicPart, IViewer viewer, EditDomain domain) {
            Request request = new Request("add_image");
            request.setViewer(viewer);
            request.setPrimaryTarget(topicPart);
            request.setParameter("paths", (Object)new String[]{path});
            domain.handleRequest(request);
        }
    }
}

