/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractTopicDecoration;

public class CircleTopicDecoration
extends AbstractTopicDecoration {
    public CircleTopicDecoration() {
    }

    public CircleTopicDecoration(String id) {
        super(id);
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        if (purpose == 3) {
            shape.addArc(box.getExpanded(this.getLineWidth() / 2, this.getLineWidth() / 2), 0.0f, 360.0f);
        } else {
            shape.addArc(box, 0.0f, 360.0f);
        }
        shape.close();
    }

    @Override
    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        double diameter = Math.sqrt(width * width + height * height);
        int margin = (this.getTopMargin() + this.getLeftMargin()) / 2;
        return new Insets((int)(diameter - (double)height) / 2 + margin, (int)(diameter - (double)width) / 2 + margin, (int)(diameter - (double)height) / 2 + margin, (int)(diameter - (double)width) / 2 + margin);
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        return Geometry.getChopOvalLocation((double)refX, (double)refY, (Rectangle)figure.getBounds(), (double)expansion);
    }
}

