/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.legacy;

import java.util.Collection;
import java.util.Collections;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.IRefCounter;
import org.xmind.core.util.ObjectRefManager;

public class RefCounterProxy
implements IRefCounter,
ICoreEventSource {
    private final Workbook workbook;
    private final Object container;
    private final String resourceType;
    private CoreEventRegister eventRegister;

    public RefCounterProxy(Workbook workbook, Object container, String resourceType) {
        this.workbook = workbook;
        this.container = container;
        this.resourceType = resourceType;
        this.eventRegister = null;
    }

    public void increaseRef(String resourceId) {
    }

    public void decreaseRef(String resourceId) {
    }

    private ObjectRefManager getRefManager() {
        return this.workbook.getAdapter(ObjectRefManager.class);
    }

    public int getRefCount(String resourceId) {
        ObjectRefManager manager = this.getRefManager();
        if (manager != null) {
            return manager.getRefCountFor(this.container, this.resourceType, resourceId);
        }
        return 0;
    }

    public Collection<String> getRefs() {
        IRefCounter counter;
        ObjectRefManager manager = this.getRefManager();
        if (manager != null && (counter = manager.getRefCounterFor(this.container, this.resourceType)) != null) {
            return counter.getRefs();
        }
        return Collections.emptySet();
    }

    public Collection<String> getCountedRefs() {
        ObjectRefManager manager = this.getRefManager();
        if (manager != null) {
            return manager.getRefsFor(this.container, this.resourceType);
        }
        return Collections.emptySet();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        ObjectRefManager manager;
        if (this.eventRegister == null && (manager = this.getRefManager()) != null) {
            this.eventRegister = new CoreEventRegister(new ICoreEventListener(){

                public void handleCoreEvent(CoreEvent event) {
                    RefCounterProxy.this.propagate(event);
                }
            });
            this.eventRegister.setNextSource((ICoreEventSource)manager);
            this.eventRegister.register("resourceRefs");
        }
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.workbook.getCoreEventSupport();
    }

    private void propagate(CoreEvent event) {
        String eResourceType = (String)event.getTarget();
        Object eContainer = event.getData();
        if (!this.resourceType.equals(eResourceType) || eContainer != this.container) {
            return;
        }
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "resourceRefs", event.getOldValue(), event.getNewValue());
    }
}

