/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddSlideCommand
extends SourceCommand {
    private PresentationStory story;
    private List<PresentationSlide> slides;
    private PresentationSlide slide;
    private int index;

    public AddSlideCommand(PresentationStory story, List<PresentationSlide> slides) {
        super(slides);
        this.story = story;
        this.slides = slides;
        VerifyUI20141031.getUsageDataCollector().increase("AddSlideCount");
    }

    public AddSlideCommand(PresentationStory story, PresentationSlide slide, int index) {
        super((Object)slide);
        this.story = story;
        this.slide = slide;
        this.index = index;
        VerifyUI20141031.getUsageDataCollector().increase("AddSlideCount");
    }

    public void redo() {
        if (this.slide != null) {
            this.story.addSlide(this.slide, this.index);
        } else if (this.slides != null) {
            for (PresentationSlide s : this.slides) {
                this.story.addSlide(s);
            }
        }
        super.redo();
    }

    public void undo() {
        if (this.slide != null) {
            this.story.deleteSlide(this.slide);
        } else if (this.slides != null) {
            for (PresentationSlide s : this.slides) {
                this.story.deleteSlide(s);
            }
        }
        super.undo();
    }
}

