/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.OrderManager;

public class Transaction {
    public final String orderID;
    public final String orderNo;
    public final String symbol;
    public final Double orderQty;
    public final OrderManager.OrdStatus orderStatus;
    public final OrderManager.OrderType orderType;
    public final OrderManager.OrderSide side;
    public final Double orderCashAmt;
    public Double limitPrice = 0.0;
    public Double stopPrice = 0.0;
    public Date createdWhen = null;
    public Date updatedWhen = null;
    public Date executedWhen = null;
    private static final Log log = LogFactory.getLog(Transaction.class);
    private static final ThreadLocal<SimpleDateFormat> utcDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };

    public Transaction(Map<String, Object> txn) {
        this.orderID = txn.get("orderId").toString();
        this.orderNo = txn.get("orderNo").toString();
        this.symbol = txn.get("symbol").toString();
        String status = txn.get("orderStatus").toString();
        this.orderStatus = status.equals(OrderManager.OrdStatus.NEW.value) ? OrderManager.OrdStatus.NEW : (status.equals(OrderManager.OrdStatus.PARTIAL_FILLED.value) ? OrderManager.OrdStatus.PARTIAL_FILLED : (status.equals(OrderManager.OrdStatus.FILLED.value) ? OrderManager.OrdStatus.FILLED : (status.equals(OrderManager.OrdStatus.CANCELED.value) ? OrderManager.OrdStatus.CANCELED : (status.equals(OrderManager.OrdStatus.REJECTED.value) ? OrderManager.OrdStatus.REJECTED : null))));
        int type = Integer.parseInt(txn.get("orderType").toString());
        if (type == OrderManager.OrderType.LIMIT.value) {
            this.orderType = OrderManager.OrderType.LIMIT;
            this.limitPrice = (Double)txn.get("limitPrice");
        } else if (type == OrderManager.OrderType.STOP.value) {
            this.orderType = OrderManager.OrderType.STOP;
            this.stopPrice = (Double)txn.get("stopPrice");
        } else {
            this.orderType = OrderManager.OrderType.MARKET;
        }
        this.orderQty = (Double)txn.get("orderQty");
        String ordSide = txn.get("side").toString();
        this.side = ordSide.equals("B") ? OrderManager.OrderSide.BUY : OrderManager.OrderSide.SELL;
        this.orderCashAmt = (Double)txn.get("orderCashAmt");
        if (txn.containsKey("createdWhen") && txn.get("createdWhen") != null) {
            this.createdWhen = Utils.getDateFromString(txn.get("createdWhen").toString());
        }
        if (txn.containsKey("updatedWhen") && txn.get("updatedWhen") != null) {
            this.updatedWhen = Utils.getDateFromString(txn.get("updatedWhen").toString());
        }
        if (txn.containsKey("executedWhen") && txn.get("executedWhen") != null) {
            this.executedWhen = Utils.getDateFromString(txn.get("executedWhen").toString());
        }
    }

    public static List<Transaction> getTransactionsAfter(List<Transaction> allTxn, Date start) {
        int size = allTxn.size();
        int offset = -1;
        for (int i = 0; i < size; ++i) {
            Transaction txn = allTxn.get(i);
            if (!txn.createdWhen.after(start) && (txn.updatedWhen == null || !txn.updatedWhen.after(start)) && (txn.executedWhen == null || !txn.executedWhen.after(start))) continue;
            offset = i;
            break;
        }
        if (offset > -1) {
            return allTxn.subList(offset, size);
        }
        return new ArrayList<Transaction>();
    }
}

