/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading;

import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.yccheok.jstock.trading.OpenPosition;

public class AccountSummary {
    private final SimpleDoubleProperty equity;
    private final SimpleDoubleProperty cashBalance;
    private final SimpleDoubleProperty cashForTrade;
    private final SimpleDoubleProperty cashForWithdraw;
    private final SimpleDoubleProperty accountTotal;
    private final SimpleDoubleProperty totalUnrealizedPL;
    private final SimpleDoubleProperty totalUnrealizedPLPercent;

    public AccountSummary(Map<String, Object> acc) {
        this.equity = new SimpleDoubleProperty(((Double)acc.get("equity")).doubleValue());
        this.cashBalance = new SimpleDoubleProperty(((Double)acc.get("cashBalance")).doubleValue());
        this.cashForTrade = new SimpleDoubleProperty(((Double)acc.get("cashForTrade")).doubleValue());
        this.cashForWithdraw = new SimpleDoubleProperty(((Double)acc.get("cashForWithdraw")).doubleValue());
        this.totalUnrealizedPL = new SimpleDoubleProperty(((Double)acc.get("totalUnrealizedPL")).doubleValue());
        this.accountTotal = new SimpleDoubleProperty();
        this.accountTotal.bind((ObservableValue)Bindings.add((ObservableNumberValue)this.cashBalance, (ObservableNumberValue)this.equity));
        this.totalUnrealizedPLPercent = new SimpleDoubleProperty();
        this.totalUnrealizedPLPercent.bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.equity.greaterThan(0)).then((ObservableNumberValue)this.totalUnrealizedPL.divide((ObservableNumberValue)this.equity.subtract((ObservableNumberValue)this.totalUnrealizedPL)).multiply(100)).otherwise(0));
    }

    public void update(ObservableList<OpenPosition> posList) {
        Double _equity = 0.0;
        Double pl = 0.0;
        for (OpenPosition pos : posList) {
            _equity = _equity + pos.getMarketValue();
            pl = pl + pos.getPl();
        }
        this.setEquity(_equity);
        this.setTotalUnrealizedPL(pl);
    }

    public final Double getEquity() {
        return this.equity.get();
    }

    public final void setEquity(Double v) {
        this.equity.set(v.doubleValue());
    }

    public DoubleProperty equityProperty() {
        return this.equity;
    }

    public final Double getCashBalance() {
        return this.cashBalance.get();
    }

    public final void setCashBalance(Double v) {
        this.cashBalance.set(v.doubleValue());
    }

    public DoubleProperty cashBalanceProperty() {
        return this.cashBalance;
    }

    public final Double getCashForTrade() {
        return this.cashForTrade.get();
    }

    public final void setCashForTrade(Double v) {
        this.cashForTrade.set(v.doubleValue());
    }

    public DoubleProperty cashForTradeProperty() {
        return this.cashForTrade;
    }

    public final Double getCashForWithdraw() {
        return this.cashForWithdraw.get();
    }

    public final void setCashForWithdraw(Double v) {
        this.cashForWithdraw.set(v.doubleValue());
    }

    public DoubleProperty cashForWithdrawProperty() {
        return this.cashForWithdraw;
    }

    public final Double getTotalUnrealizedPL() {
        return this.totalUnrealizedPL.get();
    }

    public final void setTotalUnrealizedPL(Double v) {
        this.totalUnrealizedPL.set(v.doubleValue());
    }

    public DoubleProperty totalUnrealizedPLProperty() {
        return this.totalUnrealizedPL;
    }

    public final Double getTotalUnrealizedPLPercent() {
        return this.totalUnrealizedPLPercent.get();
    }

    public final void setTotalUnrealizedPLPercent(Double v) {
        this.totalUnrealizedPLPercent.set(v.doubleValue());
    }

    public DoubleProperty totalUnrealizedPLPercentProperty() {
        return this.totalUnrealizedPLPercent;
    }

    public final Double getAccountTotal() {
        return this.accountTotal.get();
    }

    public final void setAccountTotal(Double v) {
        this.accountTotal.set(v.doubleValue());
    }

    public DoubleProperty accountTotalProperty() {
        return this.accountTotal;
    }

    public String unrealizedPLCss() {
        return this.getTotalUnrealizedPL() >= 0.0 ? "profit" : "loss";
    }
}

