/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.jdesktop.swingx.treetable.TreeTableModel;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.gui.treetable.DefaultSortableMutableTreeTableNode;
import org.yccheok.jstock.portfolio.Broker;
import org.yccheok.jstock.portfolio.ClearingFee;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.StampDuty;

public class Transaction
extends DefaultSortableMutableTreeTableNode
implements Commentable {
    private Contract contract;
    private transient Broker broker;
    private transient StampDuty stampDuty;
    private transient ClearingFee clearingFee;
    private double calculatedBroker;
    private double calculatedStampDuty;
    private double calculatdClearingFee;
    private double netTotal;
    private String comment = "";
    private transient TreeTableModel treeTableModel = null;

    public Transaction(Contract contract, double broker, double stampDuty, double clearingFee) {
        this.contract = contract;
        this.broker = null;
        this.stampDuty = null;
        this.clearingFee = null;
        this.calculatedBroker = broker;
        this.calculatedStampDuty = stampDuty;
        this.calculatdClearingFee = clearingFee;
        this.netTotal = contract.getType() == Contract.Type.Buy ? this.contract.getTotal() + this.calculatedBroker + this.calculatedStampDuty + this.calculatdClearingFee : this.contract.getTotal() - this.calculatedBroker - this.calculatedStampDuty - this.calculatdClearingFee;
    }

    public void copyFrom(Transaction transaction) {
        this.contract = new Contract(transaction.contract);
        this.calculatedBroker = transaction.calculatedBroker;
        this.calculatedStampDuty = transaction.calculatedStampDuty;
        this.calculatdClearingFee = transaction.calculatdClearingFee;
        this.netTotal = transaction.netTotal;
        this.comment = transaction.comment;
    }

    public Transaction deriveWithQuantity(double quantity) {
        return new Transaction(this.contract.deriveWithQuantity(quantity), this.calculatedBroker, this.calculatedStampDuty, this.calculatdClearingFee);
    }

    public Transaction deriveWithStockInfo(StockInfo stockInfo) {
        return new Transaction(this.contract.deriveWithStockInfo(stockInfo), this.calculatedBroker, this.calculatedStampDuty, this.calculatdClearingFee);
    }

    public Transaction deriveWithPrice(double price) {
        return new Transaction(this.contract.deriveWithPrice(price), this.calculatedBroker, this.calculatedStampDuty, this.calculatdClearingFee);
    }

    public Transaction deriveWithBroker(double broker) {
        return new Transaction(this.contract, broker, this.calculatedStampDuty, this.calculatdClearingFee);
    }

    public Transaction deriveWithStampDuty(double stampDuty) {
        return new Transaction(this.contract, this.calculatedBroker, stampDuty, this.calculatdClearingFee);
    }

    public Transaction deriveWithClearingFee(double clearingFee) {
        return new Transaction(this.contract, this.calculatedBroker, this.calculatedStampDuty, clearingFee);
    }

    public double getBroker() {
        return this.calculatedBroker;
    }

    public double getStampDuty() {
        return this.calculatedStampDuty;
    }

    public double getClearingFee() {
        return this.calculatdClearingFee;
    }

    public SimpleDate getReferenceDate() {
        return this.contract.getReferenceDate();
    }

    public Contract.Type getType() {
        return this.contract.getType();
    }

    public StockInfo getStockInfo() {
        return this.contract.getStockInfo();
    }

    public double getReferencePrice() {
        return this.contract.getReferencePrice();
    }

    public double getReferenceTotal() {
        return this.contract.getReferenceTotal();
    }

    public Contract getContract() {
        return this.contract;
    }

    public double getReferenceBroker() {
        return this.contract.getReferenceBroker();
    }

    public double getReferenceClearingFee() {
        return this.contract.getReferenceClearingFee();
    }

    public double getReferenceStampDuty() {
        return this.contract.getReferenceStampDuty();
    }

    public double getPrice() {
        return this.contract.getPrice();
    }

    public double getTotal() {
        return this.contract.getTotal();
    }

    public double getQuantity() {
        return this.contract.getQuantity();
    }

    public SimpleDate getDate() {
        return this.contract.getDate();
    }

    public double getNetReferenceTotal() {
        return this.contract.getReferenceTotal() + this.contract.getReferenceBroker() + this.contract.getReferenceClearingFee() + this.contract.getReferenceStampDuty();
    }

    public double getNetPrice() {
        return this.netTotal / this.contract.getQuantity();
    }

    public double getNetTotal() {
        return this.netTotal;
    }

    public String toString() {
        return this.contract.getStockInfo().symbol.toString();
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    private Object readResolve() {
        if (this.comment == null) {
            this.comment = "";
        }
        this.setSortable(true);
        return this;
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
    }

    @Override
    public Object getValueAt(int column) {
        return this.treeTableModel.getValueAt((Object)this, column);
    }
}

