/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class QuantityQuery {
    private final Map<Code, List<Balance>> balancesMap = new HashMap<Code, List<Balance>>();

    public QuantityQuery(List<TransactionSummary> transactionSummaries) {
        for (TransactionSummary transactionSummary : transactionSummaries) {
            Code code = ((Transaction)transactionSummary.getChildAt((int)0)).getStockInfo().code;
            int count = transactionSummary.getChildCount();
            ArrayList<Balance> tmps = new ArrayList<Balance>();
            for (int i = 0; i < count; ++i) {
                TreeTableNode o = transactionSummary.getChildAt(i);
                assert (o instanceof Transaction);
                Transaction transaction = (Transaction)o;
                if (transaction.getType() == Contract.Type.Buy) {
                    Balance balance = Balance.newInstance(transaction.getQuantity(), transaction.getDate());
                    tmps.add(balance);
                    continue;
                }
                assert (transaction.getType() == Contract.Type.Sell);
                Balance balance0 = Balance.newInstance(transaction.getQuantity(), transaction.getReferenceDate());
                Balance balance1 = Balance.newInstance(-transaction.getQuantity(), transaction.getDate());
                tmps.add(balance0);
                tmps.add(balance1);
            }
            Collections.sort(tmps, new Comparator<Balance>(){

                @Override
                public int compare(Balance o1, Balance o2) {
                    return o1.date.compareTo(o2.date);
                }
            });
            assert (!tmps.isEmpty());
            ArrayList<Balance> mergedTmps = new ArrayList<Balance>();
            Balance balance = null;
            int ej = tmps.size() - 1;
            for (int j = 0; j < ej; ++j) {
                Balance tmp0 = (Balance)tmps.get(j);
                Balance tmp1 = (Balance)tmps.get(j + 1);
                if (tmp0.date.equals(tmp1.date)) {
                    if (balance == null) {
                        balance = tmp0;
                        continue;
                    }
                    balance = Balance.newInstance(balance.quantity + tmp0.quantity, tmp0.date);
                    continue;
                }
                if (balance == null) {
                    mergedTmps.add(tmp0);
                    continue;
                }
                balance = Balance.newInstance(balance.quantity + tmp0.quantity, tmp0.date);
                mergedTmps.add(balance);
                balance = null;
            }
            Balance lastTmp = (Balance)tmps.get(tmps.size() - 1);
            if (balance == null) {
                mergedTmps.add(lastTmp);
            } else {
                balance = Balance.newInstance(balance.quantity + lastTmp.quantity, lastTmp.date);
                mergedTmps.add(balance);
                balance = null;
            }
            ArrayList<Balance> balances = new ArrayList<Balance>();
            double quantity = 0.0;
            for (Balance mergeTmp : mergedTmps) {
                Balance balance2 = Balance.newInstance(quantity += mergeTmp.quantity, mergeTmp.date);
                balances.add(balance2);
            }
            Collections.sort(balances, new Comparator<Balance>(){

                @Override
                public int compare(Balance o1, Balance o2) {
                    return -o1.date.compareTo(o2.date);
                }
            });
            this.balancesMap.put(code, balances);
        }
    }

    public double getBalance(Code code, SimpleDate date) {
        List<Balance> balances = this.balancesMap.get(code);
        if (balances == null) {
            return 0.0;
        }
        for (Balance balance : balances) {
            if (date.compareTo(balance.date) < 0) continue;
            return balance.quantity;
        }
        return 0.0;
    }

    private static final class Balance
    implements Comparable<Balance> {
        public final double quantity;
        public final SimpleDate date;

        private Balance(double quantity, SimpleDate date) {
            this.quantity = quantity;
            this.date = date;
        }

        public static Balance newInstance(double quantity, SimpleDate date) {
            return new Balance(quantity, date);
        }

        @Override
        public int compareTo(Balance o) {
            return this.date.compareTo(o.date);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.date.hashCode();
            long f = Double.doubleToLongBits(this.quantity);
            result = 31 * result + (int)(f ^ f >>> 32);
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance balance = (Balance)o;
            return this.quantity == balance.quantity && this.date.equals(balance.date);
        }
    }
}

