/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.EnumMap;
import java.util.Map;

public class Activity {
    private final Type type;
    private final double amount;
    private Map<Param, Object> paramToObject = new EnumMap<Param, Object>(Param.class);

    private Activity(Builder builder) {
        this.type = builder.type;
        this.amount = builder.amount;
        this.paramToObject = builder.paramToObject;
    }

    public Object get(Param param) {
        return this.paramToObject.get((Object)param);
    }

    public Type getType() {
        return this.type;
    }

    public double getAmount() {
        return this.amount;
    }

    public static class Builder {
        private final Type type;
        private final double amount;
        private Map<Param, Object> paramToObject = new EnumMap<Param, Object>(Param.class);

        public Builder(Type type, double amount) {
            this.type = type;
            this.amount = amount;
        }

        public Builder put(Param param, Object value) {
            this.paramToObject.put(param, value);
            return this;
        }

        public Activity build() {
            return new Activity(this);
        }
    }

    public static enum Type {
        Deposit,
        Buy,
        Sell,
        Dividend;

    }

    public static enum Param {
        StockInfo,
        Quantity;

    }
}

