/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.treetable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.gui.treetable.AbstractSortableTreeTableNode;
import org.yccheok.jstock.gui.treetable.SortableTreeTable;

public class SortableTreeTableModel
extends DefaultTreeTableModel
implements TreeExpansionListener {
    private String sortColumn = null;
    private SortOrder sortOrder = SortOrder.UNSORTED;
    private int columnIndex = -1;
    private List<TreePath> expanded;
    private SortableTreeTable treeTable = null;
    private JTableHeader header = null;
    boolean expanding = false;

    public SortableTreeTableModel() {
    }

    public SortableTreeTableModel(TreeTableNode root) {
        super(root);
    }

    public SortableTreeTableModel(TreeTableNode root, List<?> columnNames) {
        super(root, columnNames);
    }

    public void setSortColumn(String column) {
        if (column == null) {
            this.sortColumn = null;
            if (this.sortOrder.isSorted()) {
                this.sortOrder = SortOrder.UNSORTED;
                this.reset();
            }
        } else {
            this.setKeys(column, SortOrder.ASCENDING);
        }
    }

    public void setSortColumn(int column) {
        if (column == -1 || column > this.columnIdentifiers.size() - 1) {
            this.sortColumn = null;
            if (this.sortOrder.isSorted()) {
                this.sortOrder = SortOrder.UNSORTED;
                this.reset();
            }
        } else {
            this.setKeys(this.columnIdentifiers.get(column).toString(), SortOrder.ASCENDING);
        }
    }

    public void setSortOrder(SortOrder order) {
        if (this.sortColumn == null) {
            return;
        }
        if (order == null) {
            order = SortOrder.UNSORTED;
        }
        this.setKeys(this.sortColumn, order);
    }

    public void toggleSortOrder() {
        if (this.sortOrder.isAscending()) {
            this.setSortOrder(SortOrder.DESCENDING);
        } else {
            this.setSortOrder(SortOrder.ASCENDING);
        }
    }

    public void setSortOptions(String column, SortOrder order) {
        if (column == null) {
            this.setSortColumn(null);
            return;
        }
        if (order == null) {
            order = SortOrder.UNSORTED;
        }
        this.setKeys(column, order);
    }

    public void sort() {
        if (!this.sortOrder.isSorted()) {
            this.reset();
        } else {
            this.doFullSort(false);
        }
    }

    public void sort(TreeTableNode parent) {
        boolean reset = !this.sortOrder.isSorted();
        this.doSort(parent, reset);
        TreePath path = new TreePath(this.getPathToRoot(parent));
        this.modelSupport.fireTreeStructureChanged(path);
        this.reExpand();
    }

    public int getSortColumnIndex() {
        return this.columnIndex;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void insertNodeInto(MutableTreeTableNode newChild, MutableTreeTableNode parent) {
        int index = this.getChildCount(parent);
        this.insertNodeInto(newChild, parent, index);
    }

    public void setSortable(MutableTreeTableNode node, boolean sortable) {
        if (!(node instanceof AbstractSortableTreeTableNode)) {
            return;
        }
        AbstractSortableTreeTableNode n = (AbstractSortableTreeTableNode)node;
        n.setSortable(sortable);
        if (n.isSorted() && !sortable) {
            n.reset();
            TreePath path = new TreePath(this.getPathToRoot((TreeTableNode)n));
            this.modelSupport.firePathChanged(path);
        }
    }

    public void insertNodeInto(MutableTreeTableNode newChild, MutableTreeTableNode parent, int index) {
        parent.insert(newChild, index);
        if (this.sortOrder.isSorted()) {
            this.sort((TreeTableNode)parent);
        } else {
            this.modelSupport.fireChildAdded(new TreePath(this.getPathToRoot((TreeTableNode)parent)), index, (Object)newChild);
        }
    }

    public void removeNodeFromParent(MutableTreeTableNode node) {
        MutableTreeTableNode parent = (MutableTreeTableNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int index = this.getIndexOfChild(parent, node);
        this.expanded.remove(new TreePath(this.getPathToRoot((TreeTableNode)node)));
        node.removeFromParent();
        if (this.sortOrder.isSorted()) {
            this.sort((TreeTableNode)parent);
        } else {
            this.modelSupport.fireChildRemoved(new TreePath(this.getPathToRoot((TreeTableNode)parent)), index, (Object)node);
        }
    }

    public void setRoot(TreeTableNode root) {
        this.expanded = new ArrayList<TreePath>();
        super.setRoot(root);
    }

    void setTreeTable(SortableTreeTable treeTable) {
        this.treeTable = treeTable;
        this.expanded = new ArrayList<TreePath>();
        this.header = treeTable.getTableHeader();
    }

    private void setKeys(String column, SortOrder order) {
        if (this.sortColumn != null && this.sortColumn.equals(column)) {
            if (this.sortOrder.equals(order)) {
                return;
            }
        } else if (column != null) {
            int x = this.columnIdentifiers.indexOf(column);
            if (x == -1) {
                throw new IllegalArgumentException("Column " + column + " not in Column Identifiers");
            }
            this.columnIndex = x;
        }
        this.sortColumn = column;
        this.sortOrder = order;
        this.sort();
        if (this.header != null) {
            this.header.repaint();
        }
    }

    private void reset() {
        this.doFullSort(true);
    }

    private void doFullSort(boolean reset) {
        TreeTableNode root = this.getRoot();
        if (root == null) {
            return;
        }
        this.doSort(root, reset);
        this.modelSupport.fireTreeStructureChanged(new TreePath(root));
        this.reExpand();
    }

    private void doSort(TreeTableNode parent, boolean reset) {
        boolean canSort;
        AbstractSortableTreeTableNode node;
        if (parent instanceof AbstractSortableTreeTableNode) {
            node = (AbstractSortableTreeTableNode)parent;
            canSort = true;
        } else {
            node = null;
            canSort = false;
        }
        if (canSort) {
            canSort = node.canSort();
        }
        if (canSort) {
            canSort = reset ? node.isSorted() : node.canSort(this.sortColumn);
        }
        if (canSort) {
            if (reset) {
                node.reset();
            } else {
                node.sort(this.columnIndex, this.sortOrder);
            }
        } else {
            node.reset();
        }
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            TreeTableNode child = (TreeTableNode)this.getChild(parent, i);
            this.doSort(child, reset);
        }
    }

    private void reExpand() {
        if (this.treeTable == null) {
            return;
        }
        this.expanding = true;
        for (TreePath path : this.expanded) {
            this.treeTable.expandPath(path);
        }
        this.expanding = false;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent arg0) {
        TreePath p = arg0.getPath();
        this.expanded.remove(p);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent arg0) {
        if (this.expanding) {
            return;
        }
        TreePath p = arg0.getPath();
        if (!this.expanded.contains(p)) {
            this.expanded.add(p);
        }
    }
}

