/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.io.File;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.controlsfx.dialog.Wizard;
import org.controlsfx.dialog.WizardPane;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.LiveAccSignUp;
import org.yccheok.jstock.gui.trading.TradingView;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.AccountManager;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.SessionManager;

public class UploadDoc
extends Wizard {
    private static final Log log = LogFactory.getLog(UploadDoc.class);
    private Page1 page1;
    private Page2 page2;

    public UploadDoc() {
        super(null);
        this.setTitle(DriveWealthBundle.getString("Upload_doc"));
        this.page1 = new Page1();
        this.page2 = new Page2();
        Wizard.Flow branchingFlow = new Wizard.Flow(){

            public Optional<WizardPane> advance(WizardPane currentPage) {
                return Optional.of(this.getNext(currentPage));
            }

            public boolean canAdvance(WizardPane currentPage) {
                return currentPage != UploadDoc.this.page2;
            }

            private WizardPane getNext(WizardPane currentPage) {
                if (currentPage == null) {
                    return UploadDoc.this.page1;
                }
                return UploadDoc.this.page2;
            }
        };
        this.setFlow(branchingFlow);
    }

    class Page2
    extends DocWizardPane {
        public Page2() {
            this.questionLbl.setText(DriveWealthBundle.getString("Upload_proof_of_address"));
            this.noteLbl.setText(DriveWealthBundle.getString("Proof_of_address_description"));
            this.hideBtnData = ButtonBar.ButtonData.FINISH;
            this.docType = AccountManager.DocumentType.PROOF_OF_ADDRESS;
        }

        @Override
        public void simulateBtnClick() {
            this.hideBtn.fire();
            this.relogin();
        }
    }

    class Page1
    extends DocWizardPane {
        public RadioButton addressYesRb;
        public RadioButton addressNoRb;

        public Page1() {
            this.addressYesRb = new RadioButton(DriveWealthBundle.getString("Yes"));
            this.addressNoRb = new RadioButton(DriveWealthBundle.getString("No"));
            this.questionLbl.setText(DriveWealthBundle.getString("Upload_photo_ID"));
            this.noteLbl.setText(DriveWealthBundle.getString("Photo_ID_description"));
            this.hideBtnData = ButtonBar.ButtonData.NEXT_FORWARD;
            this.docType = AccountManager.DocumentType.PICTURE_ID;
            Label label = new Label(DriveWealthBundle.getString("Photo_ID_has_address"));
            label.getStyleClass().add((Object)"question");
            this.grid.addRow(this.row++, new Node[]{label});
            ToggleGroup group = new ToggleGroup();
            this.addressYesRb.setToggleGroup(group);
            this.addressNoRb.setToggleGroup(group);
            HBox hBox = new HBox();
            hBox.setAlignment(Pos.CENTER_LEFT);
            hBox.setSpacing(20.0);
            hBox.getChildren().addAll((Object[])new Node[]{this.addressYesRb, this.addressNoRb});
            GridPane.setMargin((Node)hBox, (Insets)new Insets(5.0, 0.0, 30.0, 0.0));
            this.grid.addRow(this.row++, new Node[]{hBox});
            label.managedProperty().bind((ObservableValue)label.visibleProperty());
            hBox.managedProperty().bind((ObservableValue)hBox.visibleProperty());
            label.visibleProperty().bind((ObservableValue)hBox.visibleProperty());
            hBox.visibleProperty().bind((ObservableValue)this.listView.visibleProperty());
            this.addressYesRb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    Page1.this.docType = newVal != false ? AccountManager.DocumentType.PICTURE_ID_PROOF_OF_ADDRESS : AccountManager.DocumentType.PICTURE_ID;
                }
            });
            this.sceneProperty().addListener((obs, oldScene, newScene) -> {
                if (newScene != null) {
                    GUIUtils.setDlgIcon(newScene);
                }
            });
        }

        @Override
        public void simulateBtnClick() {
            if (this.addressYesRb.isSelected()) {
                Button cancelBtn = (Button)this.lookupButton(ButtonType.CANCEL);
                cancelBtn.fire();
                this.relogin();
                return;
            }
            this.hideBtn.fire();
        }
    }

    class DocWizardPane
    extends WizardPane {
        public final StackPane stack = new StackPane();
        public final GridPane grid = new GridPane();
        public Label headerLbl1 = new Label();
        public Label headerLbl2 = new Label();
        public Label questionLbl = new Label();
        public Label noteLbl = new Label();
        public final ListView<File> listView = new ListView();
        public final ObservableList<File> files = FXCollections.observableArrayList();
        public int row = 0;
        public VBox piBox;
        public Task task;
        public Button hideBtn;
        public ButtonBar.ButtonData hideBtnData;
        public Button uploadBtn;
        public AccountManager.DocumentType docType;

        public DocWizardPane() {
            this.getStylesheets().add((Object)LiveAccSignUp.class.getResource("/css/trading.css").toExternalForm());
            this.headerLbl1.setText(DriveWealthBundle.getString("Confirm_identity"));
            this.headerLbl1.getStyleClass().add((Object)"wizard-header1");
            this.headerLbl2.setText(DriveWealthBundle.getString("Upload_doc_secure"));
            this.headerLbl2.getStyleClass().add((Object)"wizard-header2");
            this.headerLbl2.setMaxWidth(650.0);
            this.headerLbl2.setWrapText(true);
            VBox headerBox = new VBox();
            headerBox.setAlignment(Pos.CENTER_LEFT);
            headerBox.setSpacing(10.0);
            headerBox.getChildren().addAll((Object[])new Node[]{this.headerLbl1, this.headerLbl2});
            headerBox.getStyleClass().add((Object)"header-panel");
            this.setHeader((Node)headerBox);
            this.grid.setPadding(new Insets(20.0, 10.0, 20.0, 10.0));
            this.grid.setVgap(0.0);
            this.grid.setHgap(30.0);
            this.questionLbl.getStyleClass().add((Object)"question");
            this.grid.addRow(this.row++, new Node[]{this.questionLbl});
            this.noteLbl.getStyleClass().add((Object)"grey");
            GridPane.setMargin((Node)this.noteLbl, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
            this.grid.addRow(this.row++, new Node[]{this.noteLbl});
            final Button openBtn = new Button(DriveWealthBundle.getString("Add_file"));
            GridPane.setMargin((Node)openBtn, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
            this.grid.addRow(this.row++, new Node[]{openBtn});
            this.listView.setItems(this.files);
            this.listView.prefHeightProperty().bind((ObservableValue)Bindings.size(this.files).multiply(24).add(24));
            this.listView.managedProperty().bind((ObservableValue)this.listView.visibleProperty());
            this.listView.setVisible(false);
            GridPane.setMargin(this.listView, (Insets)new Insets(0.0, 0.0, 30.0, 0.0));
            this.grid.addRow(this.row++, new Node[]{this.listView});
            openBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle(DriveWealthBundle.getString("Choose_file_to_upload"));
                    fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("JPG, PNG, GIF, PDF file", new String[]{"*.png", "*.jpg", "*.gif", "*.pdf"})});
                    File selected = fileChooser.showOpenDialog(null);
                    if (selected != null) {
                        openBtn.setText(DriveWealthBundle.getString("Add_more_file"));
                        if (DocWizardPane.this.files.contains((Object)selected)) {
                            return;
                        }
                        DocWizardPane.this.files.add((Object)selected);
                        DocWizardPane.this.listView.setVisible(true);
                        Window window = DocWizardPane.this.getScene().getWindow();
                        window.sizeToScene();
                    }
                }
            });
            this.stack.getChildren().add((Object)this.grid);
            this.setContent((Node)this.stack);
        }

        public void onEnteringPage(Wizard wizard) {
            ButtonType btnType;
            int i = 0;
            while (i < this.getButtonTypes().size()) {
                btnType = (ButtonType)this.getButtonTypes().get(i++);
                ButtonBar.ButtonData btnData = btnType.getButtonData();
                if (btnData == this.hideBtnData) {
                    this.hideBtn = (Button)this.lookupButton(btnType);
                    this.hideBtn.setVisible(false);
                    this.hideBtn.setManaged(false);
                }
                if (btnData != ButtonBar.ButtonData.BACK_PREVIOUS) continue;
                Button backBtn = (Button)this.lookupButton(btnType);
                backBtn.setDisable(true);
                backBtn.setVisible(false);
                backBtn.setManaged(false);
            }
            btnType = new ButtonType(DriveWealthBundle.getString("Upload_files"), ButtonBar.ButtonData.OK_DONE);
            this.getButtonTypes().add(1, (Object)btnType);
            this.uploadBtn = (Button)this.lookupButton(btnType);
            this.uploadBtnHandler();
            this.uploadBtn.disableProperty().bind((ObservableValue)this.listView.visibleProperty().not());
        }

        private void uploadBtnHandler() {
            this.uploadBtn.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ev) {
                    ev.consume();
                    DocWizardPane.this.task = new Task<Boolean>(){

                        protected Boolean call() throws Exception {
                            Boolean success = DocWizardPane.this.uploadDoc();
                            return success;
                        }
                    };
                    DocWizardPane.this.task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                        public void handle(WorkerStateEvent workerStateEvent) {
                            Boolean success = (Boolean)workerStateEvent.getSource().getValue();
                            if (!success.booleanValue()) {
                                log.error((Object)("Upload Doc Failed - " + (Object)((Object)DocWizardPane.this.docType)));
                                DocWizardPane.this.showError();
                                return;
                            }
                            DocWizardPane.this.showNotBusy();
                            DocWizardPane.this.simulateBtnClick();
                        }
                    });
                    DocWizardPane.this.task.setOnCancelled(e -> {
                        log.error((Object)("Upload Doc Task Cancelled - " + (Object)((Object)DocWizardPane.this.docType)));
                        DocWizardPane.this.showError();
                    });
                    DocWizardPane.this.task.setOnFailed(e -> {
                        log.error((Object)("Upload Doc Task Failed - " + (Object)((Object)DocWizardPane.this.docType)));
                        DocWizardPane.this.showError();
                    });
                    Thread thread = new Thread((Runnable)DocWizardPane.this.task);
                    thread.start();
                    DocWizardPane.this.showBusy();
                }
            });
        }

        public void simulateBtnClick() {
        }

        private Boolean uploadDoc() {
            boolean success = false;
            for (File file : this.files) {
                success = AccountManager.addDocument(SessionManager.getInstance().getUser().userID, this.docType, file);
                if (success) continue;
                log.error((Object)("[uploadDoc] upload file failed - " + file));
                break;
            }
            return success;
        }

        private void showBusy() {
            ProgressIndicator pi = new ProgressIndicator();
            pi.visibleProperty().bind((ObservableValue)this.task.runningProperty());
            this.piBox = new VBox();
            this.piBox.setAlignment(Pos.CENTER);
            this.piBox.getChildren().add((Object)pi);
            this.grid.setDisable(true);
            this.stack.getChildren().add((Object)this.piBox);
            int i = 0;
            while (i < this.getButtonTypes().size()) {
                Node btn = this.lookupButton((ButtonType)this.getButtonTypes().get(i++));
                btn.visibleProperty().unbind();
                btn.visibleProperty().bind((ObservableValue)this.task.runningProperty().not());
            }
        }

        private void showNotBusy() {
            this.grid.setDisable(false);
            this.stack.getChildren().remove((Object)this.piBox);
        }

        private void showError() {
            this.showNotBusy();
            Alert alert = GUIUtils.alertDlg(Alert.AlertType.ERROR, DriveWealthBundle.getString("Upload_doc_fail"), null, ApiError.commonMsg());
            alert.show();
        }

        public void relogin() {
            Pair<String, String> credential = SessionManager.getInstance().getUsernamePassword();
            String username = (String)credential.first;
            String password = (String)credential.second;
            Pair<String, String> login = SessionManager.getInstance().login(username, password, null);
            String error = (String)login.second;
            if (error != null) {
                return;
            }
            TradingView.getInstance().showPortfolio();
        }
    }
}

