/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.text.NumberFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.internationalization.GUIBundle;

public class SplitJDialog
extends JDialog {
    private final StockInfo stockInfo;
    private Double ratio = null;
    private static final Log log = LogFactory.getLog(SplitJDialog.class);
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JFormattedTextField jFormattedTextField1;
    private JFormattedTextField jFormattedTextField2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public SplitJDialog(Frame parent, boolean modal, StockInfo stockInfo) {
        super(parent, modal);
        this.initComponents();
        this.stockInfo = stockInfo;
        this.updateGUI();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jFormattedTextField1 = this.getUnitJFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jFormattedTextField2 = this.getUnitJFormattedTextField();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jComboBox1.setModel(this.getComboBoxModel());
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitJDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jFormattedTextField1.setPreferredSize(new Dimension(40, 20));
        this.jFormattedTextField2.setPreferredSize(new Dimension(40, 20));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jLabel2.setText(bundle.getString("SplitJDialog_Unit"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFormattedTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFormattedTextField2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addContainerGap(17, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jFormattedTextField1, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jFormattedTextField2, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("SplitJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("SplitJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.updateGUI();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.jFormattedTextField1.commitEdit();
            this.jFormattedTextField2.commitEdit();
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
        Double v0 = (Double)this.jFormattedTextField1.getValue();
        Double v1 = (Double)this.jFormattedTextField2.getValue();
        if (v0 == null || v1 == null) {
            return;
        }
        double _v0 = v0;
        double _v1 = v1;
        if (_v0 <= 0.0 || _v1 <= 0.0) {
            return;
        }
        this.ratio = _v1 / _v0;
        this.setVisible(false);
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.ratio = null;
        this.setVisible(false);
        this.dispose();
    }

    private ComboBoxModel getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{GUIBundle.getString("SplitJDialog_Split"), GUIBundle.getString("SplitJDialog_Merge")});
    }

    private void updateGUI() {
        if (this.jComboBox1.getSelectedItem().equals(GUIBundle.getString("SplitJDialog_Split"))) {
            String title = MessageFormat.format(GUIBundle.getString("SplitJDialog_Split_template"), this.stockInfo.symbol);
            this.setTitle(title);
            String message = MessageFormat.format(GUIBundle.getString("SplitJDialog_UnitTo_template"), this.stockInfo.symbol);
            this.jLabel1.setText(message);
            this.jFormattedTextField1.setEditable(false);
            this.jFormattedTextField2.setEditable(true);
            this.jFormattedTextField1.setValue(new Double(1.0));
            this.jFormattedTextField2.setValue(new Double(1.0));
        } else {
            assert (this.jComboBox1.getSelectedItem().equals(GUIBundle.getString("SplitJDialog_Merge")));
            String title = MessageFormat.format(GUIBundle.getString("SplitJDialog_Merge_template"), this.stockInfo.symbol);
            this.setTitle(title);
            String message = MessageFormat.format(GUIBundle.getString("SplitJDialog_UnitTo_template"), this.stockInfo.symbol);
            this.jLabel1.setText(message);
            this.jFormattedTextField1.setEditable(true);
            this.jFormattedTextField2.setEditable(false);
            this.jFormattedTextField1.setValue(new Double(1.0));
            this.jFormattedTextField2.setValue(new Double(1.0));
        }
    }

    private JFormattedTextField getUnitJFormattedTextField() {
        DecimalFormat format = new DecimalFormat("#,##0.###");
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Double.valueOf(1.0));
        formatter.setValueClass(Double.class);
        JFormattedTextField field = new JFormattedTextField(formatter);
        return field;
    }

    public Double getRatio() {
        return this.ratio;
    }
}

