/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.analysis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.gui.Icons;
import org.yccheok.jstock.gui.IndicatorProjectManager;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.IndicatorDownloadManager;
import org.yccheok.jstock.gui.analysis.MemoryLogJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;

public class WizardDownloadIndicatorJPanel
extends JPanel {
    private volatile SwingWorker<Void, Status> downloadIndicatorTask = null;
    private final IndicatorProjectManager indicatorProjectManager;
    private List<IndicatorDownloadManager.Info> indicatorDownloadInfos;
    private final ObservableEx observable = new ObservableEx();
    private static final Log log = LogFactory.getLog(WizardDownloadIndicatorJPanel.class);
    private final List<String> memoryLog = new ArrayList<String>();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JXHeader jXHeader1;

    public WizardDownloadIndicatorJPanel(IndicatorProjectManager indicatorProjectManager) {
        this.indicatorProjectManager = indicatorProjectManager;
        this.initComponents();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("WizardDownloadlIndicatorJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/ark2.png")));
        this.jXHeader1.setTitle(bundle.getString("WizardDownloadlIndicatorJPanel_Title"));
        this.add((Component)this.jXHeader1, "North");
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jLabel1.setForeground(new Color(0, 0, 255));
        this.jLabel1.setText(bundle.getString("WizardDownloadlIndicatorJPanel_DownloadingIndicators..."));
        this.jLabel1.setForeground(Color.BLUE);
        this.jPanel1.add(this.jLabel1);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jPanel1.add(this.jLabel2);
        this.jLabel3.setText(bundle.getString("WizardDownloadlIndicatorJPanel_ViewLog"));
        this.jLabel3.setVisible(false);
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WizardDownloadIndicatorJPanel.this.jLabel3MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                WizardDownloadIndicatorJPanel.this.jLabel3MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WizardDownloadIndicatorJPanel.this.jLabel3MouseExited(evt);
            }
        });
        this.jPanel1.add(this.jLabel3);
        this.add((Component)this.jPanel1, "Center");
    }

    private void jLabel3MouseClicked(MouseEvent evt) {
        MemoryLogJDialog memoryLogJDialog = new MemoryLogJDialog((Frame)JStock.instance(), true);
        memoryLogJDialog.setLocationRelativeTo(this);
        memoryLogJDialog.setLog(this.memoryLog);
        memoryLogJDialog.setVisible(true);
    }

    private void jLabel3MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel3MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void start() {
        if (this.downloadIndicatorTask == null) {
            this.downloadIndicatorTask = this.getDownloadIndicatorTask();
            this.downloadIndicatorTask.execute();
        }
    }

    public void cancel() {
        if (this.downloadIndicatorTask != null) {
            this.downloadIndicatorTask.cancel(true);
        }
        this.downloadIndicatorTask = null;
    }

    public boolean isNextFinishButtonEnabled() {
        if (this.downloadIndicatorTask == null) {
            return false;
        }
        return this.downloadIndicatorTask.isDone();
    }

    public void setIndicatorDownloadInfos(List<IndicatorDownloadManager.Info> indicatorDownloadInfos) {
        this.indicatorDownloadInfos = indicatorDownloadInfos;
    }

    private SwingWorker<Void, Status> getDownloadIndicatorTask() {
        SwingWorker<Void, Status> worker = new SwingWorker<Void, Status>(){

            @Override
            protected void done() {
                WizardDownloadIndicatorJPanel.this.observable.setChanged();
                WizardDownloadIndicatorJPanel.this.observable.notifyObservers();
            }

            @Override
            protected void process(List<Status> statuses) {
                for (Status status : statuses) {
                    WizardDownloadIndicatorJPanel.this.writeToMemoryLog(status.message);
                    WizardDownloadIndicatorJPanel.this.jLabel1.setText(status.message);
                    WizardDownloadIndicatorJPanel.this.jLabel2.setIcon(status.icon);
                    if (status.icon == Icons.ERROR || status.icon == Icons.WARNING) {
                        WizardDownloadIndicatorJPanel.this.jLabel1.setForeground(Color.RED);
                        WizardDownloadIndicatorJPanel.this.jLabel3.setVisible(true);
                        continue;
                    }
                    WizardDownloadIndicatorJPanel.this.jLabel1.setForeground(Color.BLUE);
                    WizardDownloadIndicatorJPanel.this.jLabel3.setVisible(false);
                }
            }

            @Override
            protected Void doInBackground() {
                if (this.isCancelled()) {
                    return null;
                }
                WizardDownloadIndicatorJPanel.this.memoryLog.clear();
                int expected = WizardDownloadIndicatorJPanel.this.indicatorDownloadInfos.size();
                int actual = 0;
                for (IndicatorDownloadManager.Info info : WizardDownloadIndicatorJPanel.this.indicatorDownloadInfos) {
                    String message0 = MessageFormat.format(GUIBundle.getString("WizardDownloadlIndicatorJPanel_DownloadingIndicator_template..."), info.projectName);
                    this.publish(Status.newInstance(message0, Icons.BUSY));
                    File temp = Utils.downloadAsTempFile(info.fileURL.toString());
                    if (temp == null) {
                        String fail_message0 = MessageFormat.format(GUIBundle.getString("WizardDownloadlIndicatorJPanel_DownloadIndicatorFail_template"), info.projectName);
                        this.publish(Status.newInstance(fail_message0, Icons.BUSY));
                        continue;
                    }
                    String message1 = MessageFormat.format(GUIBundle.getString("WizardDownloadlIndicatorJPanel_CheckingCheckSum_template..."), info.projectName);
                    this.publish(Status.newInstance(message1, Icons.BUSY));
                    long checksum = org.yccheok.jstock.analysis.Utils.getChecksum(temp);
                    if (checksum != info.checksum) {
                        String fail_message1 = MessageFormat.format(GUIBundle.getString("WizardDownloadlIndicatorJPanel_CheckCheckSumFail_template"), info.projectName);
                        this.publish(Status.newInstance(fail_message1, Icons.BUSY));
                        continue;
                    }
                    if (this.isCancelled()) {
                        return null;
                    }
                    String message2 = MessageFormat.format(GUIBundle.getString("WizardDownloadlIndicatorJPanel_InstallingIndicator_template..."), info.projectName);
                    this.publish(Status.newInstance(message2, Icons.BUSY));
                    if (WizardDownloadIndicatorJPanel.this.indicatorProjectManager.install(temp)) {
                        ++actual;
                        continue;
                    }
                    String fail_message2 = MessageFormat.format(GUIBundle.getString("WizardDownloadlIndicatorJPanel_InstallIndicatorFail_template"), info.projectName);
                    this.publish(Status.newInstance(fail_message2, Icons.BUSY));
                }
                String message = MessageFormat.format(GUIBundle.getString("WizardDownloadlIndicatorJPanel_NOutOfMIndicatorsInstalledSuccessfully_template"), actual, expected);
                if (actual == expected) {
                    this.publish(Status.newInstance(message, Icons.OK));
                } else if (actual > 0) {
                    this.publish(Status.newInstance(message, Icons.WARNING));
                } else {
                    this.publish(Status.newInstance(message, Icons.ERROR));
                }
                return null;
            }
        };
        return worker;
    }

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    private void writeToMemoryLog(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
        String s = dateFormat.format(new Date()) + "\n" + message;
        this.memoryLog.add(s);
    }

    private static final class ObservableEx
    extends Observable {
        private ObservableEx() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }

    private static class Status {
        public final String message;
        public final Icon icon;

        private Status(String message, Icon icon) {
            if (message == null || icon == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.message = message;
            this.icon = icon;
        }

        public static Status newInstance(String message, Icon icon) {
            return new Status(message, icon);
        }
    }
}

