/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.google;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class SimpleSwingBrowser
extends JDialog {
    private static final Log log = LogFactory.getLog(SimpleSwingBrowser.class);
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private String loadedURL = null;
    private final JPanel panel = new JPanel(new BorderLayout());
    private String url;

    public SimpleSwingBrowser() {
        super((Window)JStock.instance(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.initMenu();
    }

    private void initMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        jMenu.setText(bundle.getString("SimpleSwingBrowser_File"));
        jMenuItem.setText(bundle.getString("SimpleSwingBrowser_OpenInBrowser"));
        jMenuItem.addActionListener(e -> {
            if (this.url != null) {
                GUIUtils.openURLInBrowser(this.url);
            }
        });
        this.setJMenuBar(jMenuBar);
    }

    private void initComponents() {
        this.createScene();
        this.jfxPanel.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    e.setKeyChar('\r');
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                }
            }
        });
        this.panel.add((Component)this.jfxPanel, "Center");
        this.getContentPane().add(this.panel);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 460) / 2, (screenSize.height - 680) / 2, 460, 680);
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final WebView view = new WebView();
                SimpleSwingBrowser.this.engine = view.getEngine();
                SimpleSwingBrowser.this.engine.setUserAgent(SimpleSwingBrowser.this.engine.getUserAgent().replace("Macintosh; ", ""));
                SimpleSwingBrowser.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowser.this.setTitle(newValue);
                            }
                        });
                    }
                });
                SimpleSwingBrowser.this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                        int result;
                        if (newValue == Worker.State.FAILED && (result = JOptionPane.showConfirmDialog(SimpleSwingBrowser.this.panel, MessagesBundle.getString("error_message_unable_connect_to_internet"), MessagesBundle.getString("error_title_unable_connect_to_internet"), 0)) == 0 && SimpleSwingBrowser.this.loadedURL != null) {
                            SimpleSwingBrowser.this.engine.load(SimpleSwingBrowser.this.loadedURL);
                        }
                    }
                });
                view.getChildrenUnmodifiable().addListener((ListChangeListener)new ListChangeListener<Node>(){

                    public void onChanged(ListChangeListener.Change<? extends Node> change) {
                        Set deadSeaScrolls = view.lookupAll(".scroll-bar");
                        for (Node scroll : deadSeaScrolls) {
                            scroll.setVisible(false);
                        }
                    }
                });
                SimpleSwingBrowser.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(final String url) {
        this.url = url;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = SimpleSwingBrowser.toURL(url);
                if (tmp == null) {
                    tmp = SimpleSwingBrowser.toURL("http://" + url);
                }
                SimpleSwingBrowser.this.loadedURL = tmp;
                SimpleSwingBrowser.this.engine.load(tmp);
            }
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }
}

