/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.yccheok.jstock.engine.BrazilYahooStockServerFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.GoogleStockServerFactory;
import org.yccheok.jstock.engine.IEXStockServerFactory;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.PriceSource;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.YahooStockServerFactory;

public enum Factories {
    INSTANCE;

    private static final Map<PriceSource, Set<Class<? extends StockServerFactory>>> priceSourceMap;
    private static final Map<Country, List<StockServerFactory>> map;
    private static final List<StockServerFactory> taiwanOTCList;

    public List<StockServerFactory> getStockServerFactories(Index index) {
        Country country = index.country;
        return this.getStockServerFactories(country);
    }

    public List<StockServerFactory> getStockServerFactories(Code code) {
        Country country = Utils.toCountry(code);
        if (country == Country.Taiwan && this.isTaiwanOTC(code)) {
            return taiwanOTCList;
        }
        return this.getStockServerFactories(country);
    }

    private boolean isTaiwanOTC(Code code) {
        String string = code.toString();
        int index = string.lastIndexOf(".");
        if (index == -1) {
            return false;
        }
        String key = string.substring(index + 1, string.length());
        return key.equalsIgnoreCase("two");
    }

    public List<StockServerFactory> getStockServerFactories(Country country) {
        List<StockServerFactory> list = map.get((Object)country);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public void updatePriceSource(Country country, PriceSource priceSource) {
        final Set<Class<? extends StockServerFactory>> classes = priceSourceMap.get((Object)priceSource);
        if (classes == null) {
            return;
        }
        List<StockServerFactory> stockServerFactories = map.get((Object)country);
        if (null == stockServerFactories) {
            return;
        }
        ArrayList<StockServerFactory> tmp = new ArrayList<StockServerFactory>(stockServerFactories);
        Collections.sort(tmp, new Comparator<StockServerFactory>(){

            @Override
            public int compare(StockServerFactory o1, StockServerFactory o2) {
                boolean result1 = classes.contains(o1.getClass());
                boolean result2 = classes.contains(o2.getClass());
                if (result1 && !result2) {
                    return -1;
                }
                if (!result1 && result2) {
                    return 1;
                }
                return 0;
            }
        });
        int ei = tmp.size();
        for (int i = 0; i < ei; ++i) {
            StockServerFactory f = (StockServerFactory)tmp.get(i);
            if (f == stockServerFactories.get(i)) continue;
            stockServerFactories.set(i, f);
        }
    }

    static {
        priceSourceMap = new EnumMap<PriceSource, Set<Class<? extends StockServerFactory>>>(PriceSource.class);
        map = new EnumMap<Country, List<StockServerFactory>>(Country.class);
        taiwanOTCList = new CopyOnWriteArrayList<StockServerFactory>();
        HashSet<Class<GoogleStockServerFactory>> googleSet = new HashSet<Class<GoogleStockServerFactory>>();
        HashSet<Class> yahooSet = new HashSet<Class>();
        HashSet<Class<IEXStockServerFactory>> iexSet = new HashSet<Class<IEXStockServerFactory>>();
        CopyOnWriteArrayList<StockServerFactory> argentinaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> australiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> austriaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> belgiumList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> brazilList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> canadaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> chinaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> denmarkList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> finlandList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> franceList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> germanyList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> hongkongList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> indiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> indonesiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> israelList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> italyList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> japanList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> koreaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> malaysiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> netherlandsList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> newZealandList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> norwayList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> polandList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> portugalList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> russiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> saudiArabiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> singaporeList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> southAfricaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> spainList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> swedenList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> switzerlandList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> taiwanList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> thailandList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> turkeyList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> unitedKingdomList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> unitedStateList = new CopyOnWriteArrayList<StockServerFactory>();
        googleSet.add(GoogleStockServerFactory.class);
        yahooSet.add(YahooStockServerFactory.class);
        yahooSet.add(BrazilYahooStockServerFactory.class);
        iexSet.add(IEXStockServerFactory.class);
        argentinaList.add(GoogleStockServerFactory.newInstance());
        argentinaList.add(YahooStockServerFactory.newInstance());
        australiaList.add(YahooStockServerFactory.newInstance());
        australiaList.add(GoogleStockServerFactory.newInstance());
        austriaList.add(YahooStockServerFactory.newInstance());
        austriaList.add(GoogleStockServerFactory.newInstance());
        belgiumList.add(YahooStockServerFactory.newInstance());
        belgiumList.add(GoogleStockServerFactory.newInstance());
        brazilList.add(BrazilYahooStockServerFactory.newInstance());
        brazilList.add(GoogleStockServerFactory.newInstance());
        canadaList.add(YahooStockServerFactory.newInstance());
        canadaList.add(GoogleStockServerFactory.newInstance());
        chinaList.add(GoogleStockServerFactory.newInstance());
        chinaList.add(YahooStockServerFactory.newInstance());
        denmarkList.add(YahooStockServerFactory.newInstance());
        denmarkList.add(GoogleStockServerFactory.newInstance());
        finlandList.add(GoogleStockServerFactory.newInstance());
        finlandList.add(YahooStockServerFactory.newInstance());
        franceList.add(YahooStockServerFactory.newInstance());
        franceList.add(GoogleStockServerFactory.newInstance());
        germanyList.add(YahooStockServerFactory.newInstance());
        germanyList.add(GoogleStockServerFactory.newInstance());
        hongkongList.add(YahooStockServerFactory.newInstance());
        hongkongList.add(GoogleStockServerFactory.newInstance());
        indiaList.add(YahooStockServerFactory.newInstance());
        indiaList.add(GoogleStockServerFactory.newInstance());
        indonesiaList.add(YahooStockServerFactory.newInstance());
        indonesiaList.add(GoogleStockServerFactory.newInstance());
        israelList.add(YahooStockServerFactory.newInstance());
        israelList.add(GoogleStockServerFactory.newInstance());
        italyList.add(YahooStockServerFactory.newInstance());
        italyList.add(GoogleStockServerFactory.newInstance());
        japanList.add(GoogleStockServerFactory.newInstance());
        koreaList.add(YahooStockServerFactory.newInstance());
        koreaList.add(GoogleStockServerFactory.newInstance());
        malaysiaList.add(YahooStockServerFactory.newInstance());
        malaysiaList.add(GoogleStockServerFactory.newInstance());
        netherlandsList.add(YahooStockServerFactory.newInstance());
        netherlandsList.add(GoogleStockServerFactory.newInstance());
        newZealandList.add(YahooStockServerFactory.newInstance());
        newZealandList.add(GoogleStockServerFactory.newInstance());
        norwayList.add(YahooStockServerFactory.newInstance());
        polandList.add(GoogleStockServerFactory.newInstance());
        portugalList.add(YahooStockServerFactory.newInstance());
        portugalList.add(GoogleStockServerFactory.newInstance());
        russiaList.add(GoogleStockServerFactory.newInstance());
        russiaList.add(YahooStockServerFactory.newInstance());
        saudiArabiaList.add(GoogleStockServerFactory.newInstance());
        singaporeList.add(GoogleStockServerFactory.newInstance());
        singaporeList.add(YahooStockServerFactory.newInstance());
        southAfricaList.add(GoogleStockServerFactory.newInstance());
        spainList.add(GoogleStockServerFactory.newInstance());
        swedenList.add(YahooStockServerFactory.newInstance());
        swedenList.add(GoogleStockServerFactory.newInstance());
        switzerlandList.add(YahooStockServerFactory.newInstance());
        switzerlandList.add(GoogleStockServerFactory.newInstance());
        taiwanList.add(GoogleStockServerFactory.newInstance());
        taiwanList.add(YahooStockServerFactory.newInstance());
        thailandList.add(GoogleStockServerFactory.newInstance());
        turkeyList.add(GoogleStockServerFactory.newInstance());
        unitedKingdomList.add(GoogleStockServerFactory.newInstance());
        unitedKingdomList.add(YahooStockServerFactory.newInstance());
        unitedStateList.add(GoogleStockServerFactory.newInstance());
        unitedStateList.add(YahooStockServerFactory.newInstance());
        unitedStateList.add(IEXStockServerFactory.newInstance());
        taiwanOTCList.add(YahooStockServerFactory.newInstance());
        priceSourceMap.put(PriceSource.Google, googleSet);
        priceSourceMap.put(PriceSource.Yahoo, yahooSet);
        priceSourceMap.put(PriceSource.IEX, iexSet);
        map.put(Country.Argentina, argentinaList);
        map.put(Country.Australia, australiaList);
        map.put(Country.Austria, austriaList);
        map.put(Country.Belgium, belgiumList);
        map.put(Country.Brazil, brazilList);
        map.put(Country.Canada, canadaList);
        map.put(Country.China, chinaList);
        map.put(Country.Denmark, denmarkList);
        map.put(Country.Finland, finlandList);
        map.put(Country.France, franceList);
        map.put(Country.Germany, germanyList);
        map.put(Country.HongKong, hongkongList);
        map.put(Country.India, indiaList);
        map.put(Country.Indonesia, indonesiaList);
        map.put(Country.Israel, israelList);
        map.put(Country.Italy, italyList);
        map.put(Country.Japan, japanList);
        map.put(Country.Korea, koreaList);
        map.put(Country.Malaysia, malaysiaList);
        map.put(Country.Netherlands, netherlandsList);
        map.put(Country.NewZealand, newZealandList);
        map.put(Country.Norway, norwayList);
        map.put(Country.Poland, polandList);
        map.put(Country.Portugal, portugalList);
        map.put(Country.Russia, russiaList);
        map.put(Country.SaudiArabia, saudiArabiaList);
        map.put(Country.Singapore, singaporeList);
        map.put(Country.SouthAfrica, southAfricaList);
        map.put(Country.Spain, spainList);
        map.put(Country.Sweden, swedenList);
        map.put(Country.Switzerland, switzerlandList);
        map.put(Country.Taiwan, taiwanList);
        map.put(Country.Thailand, thailandList);
        map.put(Country.Turkey, turkeyList);
        map.put(Country.UnitedKingdom, unitedKingdomList);
        map.put(Country.UnitedState, unitedStateList);
    }
}

