/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.BrazilYahooStockHistoryServer;
import org.yccheok.jstock.engine.BrazilYahooStockServer;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Period;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;

public class BrazilYahooStockServerFactory
implements StockServerFactory {
    private final StockServer stockServer = new BrazilYahooStockServer();
    private static final Log log = LogFactory.getLog(BrazilYahooStockServerFactory.class);

    @Override
    public char getId() {
        return 'a';
    }

    private BrazilYahooStockServerFactory() {
    }

    public static StockServerFactory newInstance() {
        return new BrazilYahooStockServerFactory();
    }

    @Override
    public StockServer getStockServer() {
        return this.stockServer;
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code) {
        try {
            return new BrazilYahooStockHistoryServer(code);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Duration duration) {
        try {
            return new BrazilYahooStockHistoryServer(code, duration);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Period period) {
        try {
            return new BrazilYahooStockHistoryServer(code, period);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public DividendServer getDividendServer() {
        return null;
    }
}

