/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import org.yccheok.jstock.analysis.AbstractOperator;
import org.yccheok.jstock.analysis.Utils;
import org.yccheok.jstock.charting.TechnicalAnalysis;
import org.yccheok.jstock.engine.Stock;

public class StockOperator
extends AbstractOperator {
    private Stock stock = null;
    private Type type = Type.LastPrice;
    private Object cache = null;

    @Override
    protected Object calculate() {
        return this.cache;
    }

    @Override
    public int getNumOfInputConnector() {
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        if (!Utils.equals((Object)oldType, (Object)this.type)) {
            this.firePropertyChange("attribute", (Object)oldType, (Object)this.type);
        }
    }

    public void setStock(Stock stock) {
        Object old = this.cache;
        this.stock = stock;
        this.cache = this.getValue(stock);
        if (!Utils.equals(old, this.cache)) {
            this.firePropertyChange("value", old, this.cache);
        }
    }

    private Object getValue(Stock stock) {
        if (stock == null) {
            return null;
        }
        switch (this.type) {
            case PrevPrice: {
                return new Double(stock.getPrevPrice());
            }
            case OpenPrice: {
                return new Double(stock.getOpenPrice());
            }
            case LastPrice: {
                return new Double(stock.getLastPrice());
            }
            case HighPrice: {
                return new Double(stock.getHighPrice());
            }
            case LowPrice: {
                return new Double(stock.getLowPrice());
            }
            case TypicalPrice: {
                return new Double(TechnicalAnalysis.getTypicalPrice(stock));
            }
            case Volume: {
                return new Long(stock.getVolume());
            }
            case ChangePrice: {
                return new Double(stock.getChangePrice());
            }
            case ChagePricePercentage: {
                return new Double(stock.getChangePricePercentage());
            }
            case LastVolume: {
                return new Integer(stock.getLastVolume());
            }
            case BuyPrice: {
                return new Double(stock.getBuyPrice());
            }
            case BuyQuantity: {
                return new Integer(stock.getBuyQuantity());
            }
            case SellPrice: {
                return new Double(stock.getSellPrice());
            }
            case SellQuantity: {
                return new Integer(stock.getSellQuantity());
            }
        }
        return null;
    }

    @Override
    public Class getInputClass(int index) {
        return null;
    }

    @Override
    public Class getOutputClass(int index) {
        return Double.class;
    }

    public static enum Type {
        PrevPrice,
        OpenPrice,
        LastPrice,
        HighPrice,
        LowPrice,
        TypicalPrice,
        Volume,
        ChangePrice,
        ChagePricePercentage,
        LastVolume,
        BuyPrice,
        BuyQuantity,
        SellPrice,
        SellQuantity;

    }
}

