/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.event.DateSelectionEvent;
import net.sf.nachocalendar.event.DateSelectionListener;
import net.sf.nachocalendar.model.DateSelectionModel;

public class DefaultDateSelectionModel
implements DateSelectionModel {
    private DateSelectionModel model = new MultipleInterval();
    private boolean isAdjusting;
    private boolean pendingEvent;
    private EventListenerList listenerList = null;

    @Override
    public void addSelectionInterval(Date from, Date to) {
        this.model.addSelectionInterval(from, to);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    @Override
    public void clearSelection() {
        this.model.clearSelection();
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    @Override
    public boolean isSelectedDate(Date date) {
        return this.model.isSelectedDate(date);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.model.isSelectionEmpty();
    }

    @Override
    public void removeSelectionInterval(Date from, Date to) {
        this.model.removeSelectionInterval(from, to);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    @Override
    public synchronized void addDateSelectionListener(DateSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DateSelectionListener.class, listener);
    }

    @Override
    public synchronized void removeDateSelectionListener(DateSelectionListener listener) {
        this.listenerList.remove(DateSelectionListener.class, listener);
    }

    private void fireDateSelectionListenerValueChanged(DateSelectionEvent event) {
        if (this.isAdjusting) {
            this.pendingEvent = true;
            return;
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DateSelectionListener.class) continue;
            ((DateSelectionListener)listeners[i + 1]).valueChanged(event);
        }
    }

    @Override
    public int getSelectionMode() {
        return this.model.getSelectionMode();
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 0: {
                this.model = new SingleSelection();
                break;
            }
            case 1: {
                this.model = new SingleInterval();
                break;
            }
            default: {
                this.model = new MultipleInterval();
            }
        }
    }

    @Override
    public Date getLeadSelectionDate() {
        return this.model.getLeadSelectionDate();
    }

    @Override
    public void setLeadSelectionDate(Date date) {
        this.model.setLeadSelectionDate(date);
    }

    @Override
    public Object getSelectedDate() {
        return this.model.getSelectedDate();
    }

    @Override
    public Object[] getSelectedDates() {
        return this.model.getSelectedDates();
    }

    @Override
    public void setSelectedDate(Object date) {
        this.model.setSelectedDate(date);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    @Override
    public void setSelectedDates(Object[] dates) {
        this.model.setSelectedDates(dates);
        this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
    }

    private static Object[] getDates(Date from, Date to) {
        ArrayList<Date> retorno = new ArrayList<Date>();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(from);
        while (to.after(cal.getTime()) || CalendarUtils.isSameDay(to, cal.getTime())) {
            retorno.add(cal.getTime());
            ((Calendar)cal).add(6, 1);
        }
        Collections.sort(retorno);
        return retorno.toArray();
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.isAdjusting = b;
        if (!b && this.pendingEvent) {
            this.fireDateSelectionListenerValueChanged(new DateSelectionEvent(this));
            this.pendingEvent = false;
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    private static class MultipleInterval
    implements DateSelectionModel {
        private List selection = new ArrayList();
        private Calendar calendar = new GregorianCalendar();
        private Date leadSelection;

        MultipleInterval() {
        }

        @Override
        public void addSelectionInterval(Date from, Date to) {
            if (from == null || to == null) {
                return;
            }
            Date d1 = null;
            Date d2 = null;
            if (from.before(to)) {
                d1 = from;
                d2 = to;
            } else {
                d1 = to;
                d2 = from;
            }
            this.calendar.setTime(d1);
            do {
                this.selection.add(this.calendar.getTime());
                this.calendar.add(6, 1);
            } while (d2.after(this.calendar.getTime()) || CalendarUtils.isSameDay(d2, this.calendar.getTime()));
            this.leadSelection = to;
        }

        @Override
        public void clearSelection() {
            this.selection.clear();
        }

        @Override
        public boolean isSelectedDate(Date date) {
            if (this.selection.isEmpty()) {
                return false;
            }
            if (date == null) {
                return false;
            }
            for (Date d : this.selection) {
                if (!CalendarUtils.isSameDay(d, date)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.selection.isEmpty();
        }

        @Override
        public void removeSelectionInterval(Date from, Date to) {
            if (from == null || to == null) {
                return;
            }
            if (from == null || to == null) {
                return;
            }
            Object[] dates = DefaultDateSelectionModel.getDates(from, to);
            block0: for (int i = 0; i < dates.length; ++i) {
                Iterator it = this.selection.iterator();
                Date d = (Date)dates[i];
                while (it.hasNext()) {
                    Date dd = (Date)it.next();
                    if (!CalendarUtils.isSameDay(d, dd)) continue;
                    this.selection.remove(dd);
                    continue block0;
                }
            }
            this.leadSelection = to;
        }

        @Override
        public void addDateSelectionListener(DateSelectionListener listener) {
        }

        @Override
        public void removeDateSelectionListener(DateSelectionListener listener) {
        }

        @Override
        public int getSelectionMode() {
            return 2;
        }

        @Override
        public void setSelectionMode(int selectionMode) {
        }

        @Override
        public Date getLeadSelectionDate() {
            return this.leadSelection;
        }

        @Override
        public void setLeadSelectionDate(Date date) {
            this.leadSelection = date;
        }

        @Override
        public Object getSelectedDate() {
            if (this.selection.isEmpty()) {
                return null;
            }
            return this.leadSelection;
        }

        @Override
        public Object[] getSelectedDates() {
            Collections.sort(this.selection);
            return this.selection.toArray();
        }

        @Override
        public void setSelectedDate(Object date) {
            this.selection.clear();
            if (date != null) {
                try {
                    this.selection.add(CalendarUtils.convertToDate(date));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void setSelectedDates(Object[] dates) {
            this.selection.clear();
            if (dates == null || dates.length < 1) {
                return;
            }
            for (int i = 0; i < dates.length; ++i) {
                try {
                    this.selection.add(CalendarUtils.convertToDate(dates[i]));
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void setValueIsAdjusting(boolean b) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }
    }

    private static class SingleInterval
    implements DateSelectionModel {
        private Date from;
        private Date to;
        private Date lead;

        private SingleInterval() {
        }

        @Override
        public void addSelectionInterval(Date from, Date to) {
            if (from == null || to == null) {
                this.from = null;
                this.to = null;
                return;
            }
            if (from.after(to)) {
                this.from = to;
                this.to = from;
            } else {
                this.from = from;
                this.to = to;
            }
            this.lead = to;
        }

        @Override
        public void clearSelection() {
            this.from = null;
            this.to = null;
        }

        @Override
        public boolean isSelectedDate(Date date) {
            if (this.from == null || this.to == null) {
                return false;
            }
            if (date == null) {
                return false;
            }
            if (CalendarUtils.isSameDay(date, this.from) || CalendarUtils.isSameDay(date, this.to)) {
                return true;
            }
            return !date.before(this.from) && !date.after(this.to);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.from == null || this.to == null;
        }

        @Override
        public void removeSelectionInterval(Date from, Date to) {
        }

        @Override
        public void addDateSelectionListener(DateSelectionListener listener) {
        }

        @Override
        public void removeDateSelectionListener(DateSelectionListener listener) {
        }

        @Override
        public int getSelectionMode() {
            return 1;
        }

        @Override
        public void setSelectionMode(int selectionMode) {
        }

        @Override
        public Date getLeadSelectionDate() {
            return this.lead;
        }

        @Override
        public void setLeadSelectionDate(Date date) {
            this.lead = date;
        }

        @Override
        public Object getSelectedDate() {
            return this.lead;
        }

        @Override
        public Object[] getSelectedDates() {
            return DefaultDateSelectionModel.getDates(this.from, this.to);
        }

        @Override
        public void setSelectedDate(Object date) {
            try {
                this.to = this.from = CalendarUtils.convertToDate(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setSelectedDates(Object[] dates) {
            if (dates == null || dates.length < 1) {
                this.from = null;
                this.to = null;
                return;
            }
            try {
                this.from = CalendarUtils.convertToDate(dates[0]);
                this.to = CalendarUtils.convertToDate(dates[dates.length - 1]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setValueIsAdjusting(boolean b) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }
    }

    private static class SingleSelection
    implements DateSelectionModel {
        private Date selection;

        private SingleSelection() {
        }

        @Override
        public void addSelectionInterval(Date from, Date to) {
            this.selection = to;
        }

        @Override
        public void clearSelection() {
            this.selection = null;
        }

        @Override
        public boolean isSelectedDate(Date date) {
            if (this.selection == null) {
                return false;
            }
            if (date == null) {
                return false;
            }
            return CalendarUtils.isSameDay(date, this.selection);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.selection == null;
        }

        @Override
        public void removeSelectionInterval(Date from, Date to) {
        }

        @Override
        public void addDateSelectionListener(DateSelectionListener listener) {
        }

        @Override
        public void removeDateSelectionListener(DateSelectionListener listener) {
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public void setSelectionMode(int selectionMode) {
        }

        @Override
        public Date getLeadSelectionDate() {
            return this.selection;
        }

        @Override
        public void setLeadSelectionDate(Date date) {
            this.selection = date;
        }

        @Override
        public Object getSelectedDate() {
            return this.selection;
        }

        @Override
        public Object[] getSelectedDates() {
            return new Object[]{this.selection};
        }

        @Override
        public void setSelectedDate(Object date) {
            if (date == null) {
                return;
            }
            try {
                this.selection = CalendarUtils.convertToDate(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setSelectedDates(Object[] dates) {
            if (dates == null) {
                return;
            }
            if (dates.length == 0) {
                this.selection = null;
                return;
            }
            try {
                this.selection = CalendarUtils.convertToDate(dates[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setValueIsAdjusting(boolean b) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }
    }
}

