/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.util.regex.Matcher;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMStorable;

public class QuickAndDirtyDOMFactory
implements DOMFactory {
    private String escape(String name) {
        name = name.replaceAll("\\$", "..");
        return name;
    }

    private String unescape(String name) {
        name = name.replaceAll("\\.\\.", Matcher.quoteReplacement("$"));
        return name;
    }

    @Override
    public String getName(DOMStorable o) {
        return this.escape(o.getClass().getName());
    }

    @Override
    public Object create(String name) {
        name = this.unescape(name);
        try {
            return Class.forName(name).newInstance();
        }
        catch (InstantiationException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Class " + name + " can not instantiate an object");
            e.initCause(ex);
            throw e;
        }
        catch (IllegalAccessException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Class " + name + " is not public");
            e.initCause(ex);
            throw e;
        }
        catch (ClassNotFoundException ex) {
            IllegalArgumentException e = new IllegalArgumentException("Class " + name + " does not exist");
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public String getEnumName(Enum o) {
        return this.escape(o.getClass().getName());
    }

    @Override
    public String getEnumValue(Enum o) {
        return o.name();
    }

    @Override
    public Enum createEnum(String name, String value) {
        Class<?> enumClass;
        name = this.unescape(name);
        try {
            enumClass = Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Enum name not known to factory:" + name);
        }
        if (enumClass == null) {
            throw new IllegalArgumentException("Enum name not known to factory:" + name);
        }
        return Enum.valueOf(enumClass, value);
    }
}

