/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import java.awt.Font;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class FontFormatter
extends DefaultFormatter {
    private boolean allowsNullValue = false;

    public FontFormatter() {
        this(true);
    }

    public FontFormatter(boolean allowsNullValue) {
        this.allowsNullValue = allowsNullValue;
        this.setOverwriteMode(false);
    }

    public void setAllowsNullValue(boolean newValue) {
        this.allowsNullValue = newValue;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    @Override
    public Object stringToValue(String str) throws ParseException {
        if (str == null || str.trim().length() == 0) {
            if (this.allowsNullValue) {
                return null;
            }
            throw new ParseException("Null value is not allowed.", 0);
        }
        Font f = Font.decode(str);
        if (f == null) {
            throw new ParseException(str, 0);
        }
        String fontName = f.getFontName();
        if (!fontName.equals(str) && !fontName.equals(str + "-Derived")) {
            throw new ParseException(str, 0);
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String valueToString(Object value) throws ParseException {
        String str = null;
        if (value == null) {
            if (!this.allowsNullValue) throw new ParseException("Null value is not allowed.", 0);
            return "";
        }
        if (!(value instanceof Font)) {
            throw new ParseException("Value is not a font " + value, 0);
        }
        Font f = (Font)value;
        return f.getFontName();
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory() {
        return FontFormatter.createFormatterFactory(false);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(boolean allowsNullValue) {
        return new DefaultFormatterFactory(new FontFormatter(allowsNullValue));
    }
}

