/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextAreaCreationTool;
import org.jhotdraw.draw.TextCreationTool;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.SelectionComponentRepainter;
import org.jhotdraw.gui.FigureAttributeEditorHandler;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JFontChooser;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionComponentDisplayer;
import org.jhotdraw.text.FontFormatter;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class FontToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;

    public FontToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString("font.toolbar"));
        JFontChooser.loadAllFonts();
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(newValue);
        if (newValue != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this){

                @Override
                public void updateVisibility() {
                    boolean newValue = this.editor != null && this.editor.getActiveView() != null && (this.isVisibleIfCreationTool && (this.editor.getTool() instanceof TextCreationTool || this.editor.getTool() instanceof TextAreaCreationTool) || this.containsTextHolderFigure(this.editor.getActiveView().getSelectedFigures()));
                    this.component.setVisible(newValue);
                    if (newValue) {
                        this.component.setPreferredSize(null);
                    } else {
                        this.component.setPreferredSize(new Dimension(0, 0));
                    }
                    this.component.revalidate();
                }

                private boolean containsTextHolderFigure(Collection<Figure> figures) {
                    for (Figure f : figures) {
                        if (f instanceof TextHolderFigure) {
                            return true;
                        }
                        if (!(f instanceof CompositeFigure) || !this.containsTextHolderFigure(((CompositeFigure)f).getChildren())) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                JPanel p1 = new JPanel(new GridBagLayout());
                JPanel p2 = new JPanel(new GridBagLayout());
                JPanel p3 = new JPanel(new GridBagLayout());
                p1.setOpaque(false);
                p2.setOpaque(false);
                p3.setOpaque(false);
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                JAttributeTextField faceField = new JAttributeTextField();
                faceField.setColumns(2);
                faceField.setToolTipText(labels.getString("attribute.font.toolTipText"));
                faceField.setHorizontalAlignment(4);
                faceField.putClientProperty("Palette.Component.segmentPosition", "first");
                faceField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(faceField));
                faceField.setHorizontalAlignment(10);
                faceField.setFormatterFactory(FontFormatter.createFormatterFactory());
                new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_FACE, faceField, this.editor);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gbc.anchor = 23;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                p.add(faceField, gbc);
                JButton btn = ButtonFactory.createFontButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridwidth = 0;
                gbc.anchor = 17;
                p.add((Component)btn, gbc);
                JAttributeTextField sizeField = new JAttributeTextField();
                sizeField.setColumns(1);
                sizeField.setToolTipText(labels.getString("attribute.fontSize.toolTipText"));
                sizeField.setHorizontalAlignment(4);
                sizeField.putClientProperty("Palette.Component.segmentPosition", "first");
                sizeField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(sizeField));
                sizeField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
                sizeField.setHorizontalAlignment(10);
                new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_SIZE, sizeField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.anchor = 23;
                gbc.gridwidth = 2;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                p2.add(sizeField, gbc);
                JPopupButton sizePopupButton = new JPopupButton();
                JAttributeSlider sizeSlider = new JAttributeSlider(1, 0, 100, 12);
                sizePopupButton.add(sizeSlider);
                labels.configureToolBarButton(sizePopupButton, "attribute.fontSize");
                sizePopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(sizePopupButton));
                sizePopupButton.setPopupAnchor(4);
                new SelectionComponentRepainter(this.editor, sizePopupButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 1;
                gbc.anchor = 23;
                gbc.insets = new Insets(3, 0, 0, 0);
                p2.add((Component)sizePopupButton, gbc);
                sizeSlider.setUI((SliderUI)PaletteSliderUI.createUI(sizeSlider));
                sizeSlider.setScaleFactor(1.0);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FONT_SIZE, sizeSlider, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.gridwidth = 2;
                gbc.fill = 1;
                gbc.anchor = 23;
                gbc.insets = new Insets(0, 0, 0, 0);
                p.add((Component)p2, gbc);
                btn = ButtonFactory.createFontStyleBoldButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.putClientProperty("Palette.Component.segmentPosition", "first");
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createFontStyleItalicButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.putClientProperty("Palette.Component.segmentPosition", "middle");
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createFontStyleUnderlineButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.putClientProperty("Palette.Component.segmentPosition", "last");
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.anchor = 17;
                p.add((Component)btn, gbc);
                break;
            }
            case 2: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                JPanel p1 = new JPanel(new GridBagLayout());
                JPanel p2 = new JPanel(new GridBagLayout());
                JPanel p3 = new JPanel(new GridBagLayout());
                p1.setOpaque(false);
                p2.setOpaque(false);
                p3.setOpaque(false);
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                JAttributeTextField faceField = new JAttributeTextField();
                faceField.setColumns(10);
                faceField.setToolTipText(labels.getString("attribute.font.toolTipText"));
                faceField.setHorizontalAlignment(4);
                faceField.putClientProperty("Palette.Component.segmentPosition", "first");
                faceField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(faceField));
                faceField.setHorizontalAlignment(10);
                faceField.setFormatterFactory(FontFormatter.createFormatterFactory());
                new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_FACE, faceField, this.editor);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gbc.anchor = 23;
                gbc.gridwidth = 3;
                gbc.fill = 2;
                p.add(faceField, gbc);
                JButton btn = ButtonFactory.createFontButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridwidth = 0;
                gbc.anchor = 17;
                p.add((Component)btn, gbc);
                JAttributeTextField sizeField = new JAttributeTextField();
                sizeField.setColumns(1);
                sizeField.setToolTipText(labels.getString("attribute.fontSize.toolTipText"));
                sizeField.setHorizontalAlignment(4);
                sizeField.putClientProperty("Palette.Component.segmentPosition", "first");
                sizeField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(sizeField));
                sizeField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
                sizeField.setHorizontalAlignment(10);
                new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_SIZE, sizeField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.anchor = 23;
                gbc.gridwidth = 2;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                p2.add(sizeField, gbc);
                JPopupButton sizePopupButton = new JPopupButton();
                JAttributeSlider sizeSlider = new JAttributeSlider(1, 0, 100, 12);
                sizePopupButton.add(sizeSlider);
                labels.configureToolBarButton(sizePopupButton, "attribute.fontSize");
                sizePopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(sizePopupButton));
                sizePopupButton.setPopupAnchor(4);
                new SelectionComponentRepainter(this.editor, sizePopupButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 1;
                gbc.anchor = 23;
                gbc.insets = new Insets(3, 0, 0, 0);
                p2.add((Component)sizePopupButton, gbc);
                sizeSlider.setUI((SliderUI)PaletteSliderUI.createUI(sizeSlider));
                sizeSlider.setScaleFactor(1.0);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FONT_SIZE, sizeSlider, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.gridwidth = 2;
                gbc.fill = 1;
                gbc.anchor = 23;
                gbc.insets = new Insets(0, 0, 0, 0);
                p.add((Component)p2, gbc);
                btn = ButtonFactory.createFontStyleBoldButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.putClientProperty("Palette.Component.segmentPosition", "first");
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createFontStyleItalicButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.putClientProperty("Palette.Component.segmentPosition", "middle");
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createFontStyleUnderlineButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.putClientProperty("Palette.Component.segmentPosition", "last");
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.anchor = 17;
                p.add((Component)btn, gbc);
            }
        }
        return p;
    }

    @Override
    protected String getID() {
        return "font";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
    }
}

