/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.app.ExportableView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingPageable;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.PictImageInputFormat;
import org.jhotdraw.draw.QuadTreeDrawing;
import org.jhotdraw.draw.TextInputFormat;
import org.jhotdraw.samples.svg.SVGDrawingPanel;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGView
extends AbstractView
implements ExportableView {
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    protected JFileChooser exportChooser;
    private UndoRedoManager undo;
    private HashMap<FileFilter, InputFormat> fileFilterInputFormatMap;
    private HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap;
    private SVGDrawingPanel svgPanel;

    @Override
    public void init() {
        super.init();
        this.initComponents();
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        this.undo = new UndoRedoManager();
        this.svgPanel.setDrawing(this.createDrawing());
        this.svgPanel.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SVGView.this.setHasUnsavedChanges(SVGView.this.undo.hasSignificantEdits());
            }
        });
    }

    protected Drawing createDrawing() {
        QuadTreeDrawing drawing = new QuadTreeDrawing();
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(new SVGZInputFormat());
        inputFormats.add(new ImageInputFormat(new SVGImageFigure()));
        inputFormats.add(new ImageInputFormat(new SVGImageFigure(), "JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        inputFormats.add(new ImageInputFormat(new SVGImageFigure(), "GIF", "Graphics Interchange Format (GIF)", "gif", 2));
        inputFormats.add(new ImageInputFormat(new SVGImageFigure(), "PNG", "Portable Network Graphics (PNG)", "png", 2));
        inputFormats.add(new PictImageInputFormat(new SVGImageFigure()));
        inputFormats.add(new TextInputFormat(new SVGTextFigure()));
        drawing.setInputFormats(inputFormats);
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(new SVGOutputFormat());
        outputFormats.add(new SVGZOutputFormat());
        outputFormats.add(new ImageOutputFormat());
        outputFormats.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        outputFormats.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        outputFormats.add(new ImageMapOutputFormat());
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.svgPanel.getDrawing());
    }

    public DrawingEditor getEditor() {
        return this.svgPanel.getEditor();
    }

    public void setEditor(DrawingEditor newValue) {
        this.svgPanel.setEditor(newValue);
    }

    private void initActions() {
        this.putAction("edit.undo", this.undo.getUndoAction());
        this.putAction("edit.redo", this.undo.getRedoAction());
    }

    @Override
    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File f) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(f));
            new SVGOutputFormat().write(f, this.svgPanel.getDrawing());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void read(File f) throws IOException {
        try {
            JFileChooser fc = this.getOpenChooser();
            final Drawing drawing = this.createDrawing();
            InputFormat selectedFormat = this.fileFilterInputFormatMap.get(fc.getFileFilter());
            boolean success = false;
            if (selectedFormat != null) {
                try {
                    selectedFormat.read(f, drawing, true);
                    success = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!success) {
                for (InputFormat sfi : drawing.getInputFormats()) {
                    if (sfi == selectedFormat) continue;
                    try {
                        sfi.read(f, drawing, true);
                        success = true;
                        break;
                    }
                    catch (Exception e) {
                    }
                }
            }
            if (!success) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                throw new IOException(labels.getFormatted("file.open.unsupportedFileFormat.message", f.getName()));
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SVGView.this.svgPanel.getDrawing().removeUndoableEditListener(SVGView.this.undo);
                    SVGView.this.svgPanel.setDrawing(drawing);
                    SVGView.this.svgPanel.getDrawing().addUndoableEditListener(SVGView.this.undo);
                    SVGView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
    }

    public Drawing getDrawing() {
        return this.svgPanel.getDrawing();
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.svgPanel.setEnabled(newValue);
        super.setEnabled(newValue);
    }

    @Override
    public void clear() {
        final Drawing newDrawing = this.createDrawing();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SVGView.this.svgPanel.getDrawing().removeUndoableEditListener(SVGView.this.undo);
                    SVGView.this.svgPanel.setDrawing(newDrawing);
                    SVGView.this.svgPanel.getDrawing().addUndoableEditListener(SVGView.this.undo);
                    SVGView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected JFileChooser createOpenChooser() {
        final JFileChooser c = new JFileChooser();
        this.fileFilterInputFormatMap = new HashMap();
        FileFilter firstFF = null;
        for (InputFormat format : this.svgPanel.getDrawing().getInputFormats()) {
            FileFilter ff = format.getFileFilter();
            if (firstFF == null) {
                firstFF = ff;
            }
            this.fileFilterInputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        c.setFileFilter(firstFF);
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    InputFormat inputFormat = (InputFormat)SVGView.this.fileFilterInputFormatMap.get(evt.getNewValue());
                    c.setAccessory(inputFormat == null ? null : inputFormat.getInputFormatAccessory());
                }
            }
        });
        if (this.preferences != null) {
            c.setSelectedFile(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    @Override
    protected JFileChooser createSaveChooser() {
        JFileChooser c = new JFileChooser();
        this.fileFilterOutputFormatMap = new HashMap();
        Iterator<OutputFormat> i$ = this.svgPanel.getDrawing().getOutputFormats().iterator();
        if (i$.hasNext()) {
            OutputFormat format = i$.next();
            FileFilter ff = format.getFileFilter();
            this.fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        if (this.preferences != null) {
            c.setSelectedFile(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    protected JFileChooser createExportChooser() {
        JFileChooser c = new JFileChooser();
        this.fileFilterOutputFormatMap = new HashMap();
        FileFilter currentFilter = null;
        for (OutputFormat format : this.svgPanel.getDrawing().getOutputFormats()) {
            FileFilter ff = format.getFileFilter();
            this.fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
            if (!ff.getDescription().equals(this.preferences.get("viewExportFormat", ""))) continue;
            currentFilter = ff;
        }
        if (currentFilter != null) {
            c.setFileFilter(currentFilter);
        }
        c.setSelectedFile(new File(this.preferences.get("viewExportFile", System.getProperty("user.home"))));
        return c;
    }

    @Override
    public boolean canSaveTo(File file) {
        return file.getName().endsWith(".svg") || file.getName().endsWith(".svgz");
    }

    private void initComponents() {
        this.svgPanel = new SVGDrawingPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.svgPanel, "Center");
    }

    @Override
    public JFileChooser getExportChooser() {
        if (this.exportChooser == null) {
            this.exportChooser = this.createExportChooser();
        }
        return this.exportChooser;
    }

    @Override
    public void export(File f, FileFilter filter, Component accessory) throws IOException {
        OutputFormat format = this.fileFilterOutputFormatMap.get(filter);
        if (!f.getName().endsWith("." + format.getFileExtension())) {
            f = new File(f.getPath() + "." + format.getFileExtension());
        }
        format.write(f, this.svgPanel.getDrawing());
        this.preferences.put("viewExportFile", f.getPath());
        this.preferences.put("viewExportFormat", filter.getDescription());
    }
}

