/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.gui.ToolBarLayout;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.samples.svg.gui.ActionsToolBar;
import org.jhotdraw.samples.svg.gui.AlignToolBar;
import org.jhotdraw.samples.svg.gui.ArrangeToolBar;
import org.jhotdraw.samples.svg.gui.CanvasToolBar;
import org.jhotdraw.samples.svg.gui.FigureToolBar;
import org.jhotdraw.samples.svg.gui.FillToolBar;
import org.jhotdraw.samples.svg.gui.FontToolBar;
import org.jhotdraw.samples.svg.gui.LinkToolBar;
import org.jhotdraw.samples.svg.gui.StrokeToolBar;
import org.jhotdraw.samples.svg.gui.ToolsToolBar;
import org.jhotdraw.samples.svg.gui.ViewToolBar;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGDrawingPanel
extends JPanel {
    private UndoRedoManager undoManager;
    private DrawingEditor editor;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    private Preferences prefs;
    private ActionsToolBar actionToolBar;
    private AlignToolBar alignToolBar;
    private ArrangeToolBar arrangeToolBar;
    private CanvasToolBar canvasToolBar;
    private ToolsToolBar creationToolBar;
    private FigureToolBar figureToolBar;
    private FillToolBar fillToolBar;
    private FontToolBar fontToolBar;
    private LinkToolBar linkToolBar;
    private JScrollPane scrollPane;
    private StrokeToolBar strokeToolBar;
    private ButtonGroup toolButtonGroup;
    private JPanel toolsPane;
    private JPanel toolsPanel;
    private JScrollPane toolsScrollPane;
    private DefaultDrawingView view;
    private ViewToolBar viewToolBar;

    public SVGDrawingPanel() {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        try {
            this.prefs = Preferences.userNodeForPackage(this.getClass());
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.initComponents();
        this.toolsPane.setLayout(new ToolBarLayout());
        this.toolsPane.setBackground(new Color(0xF0F0F0));
        this.toolsPane.setOpaque(true);
        this.viewToolBar.setView(this.view);
        this.undoManager = new UndoRedoManager();
        this.setEditor(new DefaultDrawingEditor());
        this.editor.setHandleAttribute(HandleAttributeKeys.HANDLE_SIZE, new Integer(7));
        DefaultDrawing drawing = new DefaultDrawing();
        this.view.setDrawing(drawing);
        drawing.addUndoableEditListener(this.undoManager);
        ArrayList<JToolBar> sortme = new ArrayList<JToolBar>();
        for (Component c : this.toolsPane.getComponents()) {
            if (!(c instanceof JToolBar)) continue;
            sortme.add((JToolBar)c);
        }
        Collections.sort(sortme, new Comparator<JToolBar>(){

            @Override
            public int compare(JToolBar tb1, JToolBar tb2) {
                int i1 = SVGDrawingPanel.this.prefs.getInt("toolBarIndex." + tb1.getName(), 0);
                int i2 = SVGDrawingPanel.this.prefs.getInt("toolBarIndex." + tb2.getName(), 0);
                return i1 - i2;
            }
        });
        this.toolsPane.removeAll();
        for (JToolBar tb : sortme) {
            this.toolsPane.add(tb);
        }
        this.toolsPane.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                int i = 0;
                for (Component c : SVGDrawingPanel.this.toolsPane.getComponents()) {
                    if (!(c instanceof JToolBar)) continue;
                    JToolBar tb = (JToolBar)c;
                    SVGDrawingPanel.this.prefs.putInt("toolBarIndex." + tb.getName(), i);
                    ++i;
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        });
    }

    public void setDrawing(Drawing d) {
        this.undoManager.discardAllEdits();
        this.view.getDrawing().removeUndoableEditListener(this.undoManager);
        this.view.setDrawing(d);
        d.addUndoableEditListener(this.undoManager);
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        if (newValue != null) {
            newValue.add(this.view);
        }
        this.creationToolBar.setEditor(this.editor);
        this.fillToolBar.setEditor(this.editor);
        this.strokeToolBar.setEditor(this.editor);
        this.actionToolBar.setUndoManager(this.undoManager);
        this.actionToolBar.setEditor(this.editor);
        this.alignToolBar.setEditor(this.editor);
        this.arrangeToolBar.setEditor(this.editor);
        this.fontToolBar.setEditor(this.editor);
        this.figureToolBar.setEditor(this.editor);
        this.linkToolBar.setEditor(this.editor);
        DrawingView temp = this.editor.getActiveView();
        this.editor.setActiveView(this.view);
        this.canvasToolBar.setEditor(this.editor);
        this.viewToolBar.setEditor(this.editor);
        this.editor.setActiveView(temp);
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.toolsPanel = new JPanel();
        this.toolsScrollPane = new JScrollPane();
        this.toolsPane = new JPanel();
        this.creationToolBar = new ToolsToolBar();
        this.actionToolBar = new ActionsToolBar();
        this.fillToolBar = new FillToolBar();
        this.strokeToolBar = new StrokeToolBar();
        this.fontToolBar = new FontToolBar();
        this.arrangeToolBar = new ArrangeToolBar();
        this.alignToolBar = new AlignToolBar();
        this.figureToolBar = new FigureToolBar();
        this.linkToolBar = new LinkToolBar();
        this.canvasToolBar = new CanvasToolBar();
        this.viewToolBar = new ViewToolBar();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.toolsPanel.setBackground(new Color(255, 255, 255));
        this.toolsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toolsPanel.setOpaque(true);
        this.toolsPanel.setLayout(new GridBagLayout());
        this.toolsScrollPane.setBorder(PaletteLookAndFeel.getInstance().getBorder("Ribbon.border"));
        this.toolsScrollPane.setHorizontalScrollBarPolicy(32);
        this.toolsScrollPane.setVerticalScrollBarPolicy(21);
        this.toolsScrollPane.setMinimumSize(new Dimension(0, 0));
        this.toolsPane.setForeground(new Color(153, 153, 153));
        this.toolsPane.add(this.creationToolBar);
        this.toolsPane.add(this.actionToolBar);
        this.toolsPane.add(this.fillToolBar);
        this.strokeToolBar.setMargin(new Insets(0, 10, 0, 0));
        this.toolsPane.add(this.strokeToolBar);
        this.toolsPane.add(this.fontToolBar);
        this.toolsPane.add(this.arrangeToolBar);
        this.toolsPane.add(this.alignToolBar);
        this.toolsPane.add(this.figureToolBar);
        this.toolsPane.add(this.linkToolBar);
        this.toolsPane.add(this.canvasToolBar);
        this.toolsPane.add(this.viewToolBar);
        this.toolsScrollPane.setViewportView(this.toolsPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.toolsPanel.add((Component)this.toolsScrollPane, gridBagConstraints);
        this.add((Component)this.toolsPanel, "South");
    }

    public JComponent getComponent() {
        return this;
    }

    private class ItemChangeHandler
    implements ItemListener {
        private JToolBar toolbar;
        private String prefkey;

        public ItemChangeHandler(JToolBar toolbar, String prefkey) {
            this.toolbar = toolbar;
            this.prefkey = prefkey;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean b = e.getStateChange() == 1;
            this.toolbar.setVisible(b);
            SVGDrawingPanel.this.prefs.putBoolean(this.prefkey, b);
            SVGDrawingPanel.this.validate();
        }
    }
}

