/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AttributeAction;

public class EditorColorChooserAction
extends AttributeAction {
    protected AttributeKey<Color> key;
    protected static JColorChooser colorChooser;

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key) {
        this(editor, key, null, null);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, Icon icon) {
        this(editor, key, null, icon);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, String name) {
        this(editor, key, name, null);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, String name, Icon icon) {
        this(editor, key, name, icon, new HashMap<AttributeKey, Object>());
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, String name, Icon icon, Map<AttributeKey, Object> fixedAttributes) {
        super(editor, fixedAttributes, name, icon);
        this.key = key;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        Color initialColor = this.getInitialColor();
        Color chosenColor = JColorChooser.showDialog((Component)e.getSource(), this.labels.getString("attribute.color.text"), initialColor);
        if (chosenColor != null) {
            HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>(this.attributes);
            attr.put(this.key, chosenColor);
            this.applyAttributesTo(attr, this.getView().getSelectedFigures());
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }

    protected Color getInitialColor() {
        Color initialColor = this.getEditor().getDefaultAttribute(this.key);
        if (initialColor == null) {
            initialColor = Color.red;
        }
        return initialColor;
    }
}

