/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.gui.JLifeFormattedTextField;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class EditGridPanel
extends JPanel {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    private GridConstrainer constrainer;
    private JLifeFormattedTextField heightField;
    private JLabel heightLabel;
    private JLifeFormattedTextField thetaField;
    private JLabel thetaLabel;
    private JLifeFormattedTextField widthField;
    private JLabel widthLabel;

    public EditGridPanel() {
        this.initComponents();
        this.widthField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
        this.heightField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
        this.thetaField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 180.0, 1.0));
        this.constrainer = new GridConstrainer(10.0, 10.0);
        this.widthField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    EditGridPanel.this.constrainer.setWidth((Double)evt.getNewValue());
                }
            }
        });
        this.heightField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    EditGridPanel.this.constrainer.setHeight((Double)evt.getNewValue());
                }
            }
        });
        this.thetaField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    EditGridPanel.this.constrainer.setTheta((Double)evt.getNewValue() * Math.PI / 180.0);
                }
            }
        });
    }

    public void setConstrainer(GridConstrainer newValue) {
        this.constrainer = newValue;
        this.widthField.setValue(this.constrainer.getWidth());
        this.heightField.setValue(this.constrainer.getHeight());
        this.thetaField.setValue(this.constrainer.getTheta() * 180.0 / Math.PI);
    }

    public GridConstrainer getConstrainer() {
        return this.constrainer;
    }

    private void initComponents() {
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.widthField = new JLifeFormattedTextField();
        this.heightField = new JLifeFormattedTextField();
        this.thetaLabel = new JLabel();
        this.thetaField = new JLifeFormattedTextField();
        this.widthLabel.setText(this.labels.getString("view.grid.width.text"));
        this.heightLabel.setText(this.labels.getString("view.grid.height.text"));
        this.widthField.setColumns(5);
        this.heightField.setColumns(5);
        this.thetaLabel.setText(this.labels.getString("view.grid.theta.text"));
        this.thetaField.setColumns(5);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.heightLabel).add(2, (Component)this.widthLabel).add(2, (Component)this.thetaLabel)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.thetaField, -2, -1, -2).add((Component)this.heightField, -2, -1, -2).add((Component)this.widthField, -2, -1, -2)).addContainerGap(67, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.thetaLabel).add((Component)this.thetaField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

