/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public abstract class AbstractDrawingViewAction
extends AbstractAction {
    private DrawingEditor editor;
    private DrawingView view;
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                AbstractDrawingViewAction.this.updateEnabledState();
            } else if (evt.getPropertyName() == "activeView") {
                DrawingView view;
                if (evt.getOldValue() != null) {
                    view = (DrawingView)evt.getOldValue();
                    view.removePropertyChangeListener(AbstractDrawingViewAction.this.propertyChangeHandler);
                }
                if (evt.getNewValue() != null) {
                    view = (DrawingView)evt.getNewValue();
                    view.addPropertyChangeListener(AbstractDrawingViewAction.this.propertyChangeHandler);
                    AbstractDrawingViewAction.this.updateEnabledState();
                }
            }
        }
    };

    public AbstractDrawingViewAction(DrawingEditor editor) {
        this.setEditor(editor);
    }

    public AbstractDrawingViewAction(DrawingView view) {
        this.view = view;
    }

    protected void setEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.propertyChangeHandler);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.propertyChangeHandler);
        }
    }

    protected DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.view != null ? this.view : (this.editor != null ? this.editor.getActiveView() : null);
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.getDrawing().fireUndoableEditHappened(edit);
    }

    protected void viewChanged() {
    }

    public void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled());
        } else {
            this.setEnabled(false);
        }
    }
}

