/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.TextHolderFigure;

public class FontSizeLocator
implements Locator {
    @Override
    public Point2D.Double locate(Figure owner) {
        Point2D.Double p = (Point2D.Double)owner.getStartPoint().clone();
        if (owner instanceof TextHolderFigure) {
            p.y += (double)((TextHolderFigure)owner).getFontSize();
            p.y += ((TextHolderFigure)owner).getInsets().top;
        } else {
            p.y += AttributeKeys.FONT_SIZE.get(owner).doubleValue();
        }
        if (AttributeKeys.TRANSFORM.get(owner) != null) {
            AttributeKeys.TRANSFORM.get(owner).transform(p, p);
        }
        return p;
    }

    @Override
    public Point2D.Double locate(Figure owner, Figure dependent) {
        return this.locate(owner);
    }
}

