/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public abstract class AbstractDrawing
extends AbstractAttributedCompositeFigure
implements Drawing {
    private static final Object lock = new JPanel().getTreeLock();
    private transient FontRenderContext fontRenderContext;
    private LinkedList<InputFormat> inputFormats = new LinkedList();
    private LinkedList<OutputFormat> outputFormats = new LinkedList();
    private static final boolean DEBUG = false;

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        this.listenerList.add(UndoableEditListener.class, l);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener l) {
        this.listenerList.remove(UndoableEditListener.class, l);
    }

    @Override
    public void fireUndoableEditHappened(UndoableEdit edit) {
        UndoableEditEvent event = null;
        if (this.listenerList.getListenerCount() > 0) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (event == null) {
                    event = new UndoableEditEvent(this, edit);
                }
                if (listeners[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)listeners[i + 1]).undoableEditHappened(event);
            }
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public void setFontRenderContext(FontRenderContext frc) {
        this.fontRenderContext = frc;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement("figures");
        for (int i = 0; i < in.getElementCount(); ++i) {
            Figure f = (Figure)in.readObject(i);
            this.add(f);
        }
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("figures");
        for (Figure f : this.getChildren()) {
            out.writeObject(f);
        }
        out.closeElement();
    }

    @Override
    public Object getLock() {
        return lock;
    }

    @Override
    public void addInputFormat(InputFormat format) {
        this.inputFormats.add(format);
    }

    @Override
    public void addOutputFormat(OutputFormat format) {
        this.outputFormats.add(format);
    }

    @Override
    public void setOutputFormats(List<OutputFormat> formats) {
        this.outputFormats = new LinkedList<OutputFormat>(formats);
    }

    @Override
    public void setInputFormats(List<InputFormat> formats) {
        this.inputFormats = new LinkedList<InputFormat>(formats);
    }

    @Override
    public List<InputFormat> getInputFormats() {
        return this.inputFormats;
    }

    @Override
    public List<OutputFormat> getOutputFormats() {
        return this.outputFormats;
    }

    @Override
    public Drawing getDrawing() {
        return this;
    }
}

