/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import org.jhotdraw.app.DefaultOSXApplication;

public class OSXTogglePaletteAction
extends AbstractAction {
    private Window palette;
    private DefaultOSXApplication app;
    private WindowListener windowHandler;

    public OSXTogglePaletteAction(DefaultOSXApplication app, Window palette, String label) {
        super(label);
        this.app = app;
        this.windowHandler = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OSXTogglePaletteAction.this.putValue("selected", false);
            }
        };
        this.setPalette(palette);
        this.putValue("selected", true);
    }

    @Override
    public void putValue(String key, Object newValue) {
        super.putValue(key, newValue);
        if (key == "selected" && this.palette != null) {
            boolean b = (Boolean)newValue;
            if (b) {
                this.app.addPalette(this.palette);
                this.palette.setVisible(true);
            } else {
                this.app.removePalette(this.palette);
                this.palette.setVisible(false);
            }
        }
    }

    public void setPalette(Window newValue) {
        if (this.palette != null) {
            this.palette.removeWindowListener(this.windowHandler);
        }
        this.palette = newValue;
        if (this.palette != null) {
            this.palette.addWindowListener(this.windowHandler);
            if (this.getValue("selected") == Boolean.TRUE) {
                this.app.addPalette(this.palette);
                this.palette.setVisible(true);
            } else {
                this.app.removePalette(this.palette);
                this.palette.setVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.palette != null) {
            this.putValue("selected", !this.palette.isVisible());
        }
    }
}

