/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractSaveBeforeAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class LoadAction
extends AbstractSaveBeforeAction {
    public static final String ID = "file.load";

    public LoadAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, "file.open");
    }

    protected JFileChooser getFileChooser(View view) {
        return view.getOpenChooser();
    }

    @Override
    public void doIt(View view) {
        JFileChooser fileChooser = this.getFileChooser(view);
        if (fileChooser.showOpenDialog(view.getComponent()) == 0) {
            this.openFile(view, fileChooser);
        } else {
            view.setEnabled(true);
        }
    }

    protected void openFile(final View view, JFileChooser fileChooser) {
        final File file = fileChooser.getSelectedFile();
        view.setEnabled(false);
        view.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    view.read(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                LoadAction.this.fileOpened(view, file, value);
            }
        });
    }

    protected void fileOpened(final View view, File file, Object value) {
        if (value == null) {
            view.setFile(file);
            view.setEnabled(true);
            this.getApplication().addRecentFile(file);
        } else {
            JSheet.showMessageSheet(view.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    view.clear();
                    view.setEnabled(true);
                }
            });
        }
    }
}

