/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ExportableView;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class ExportAction
extends AbstractViewAction {
    public static final String ID = "file.export";
    private Component oldFocusOwner;

    public ExportAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final ExportableView view = (ExportableView)this.getActiveView();
        if (view.isEnabled()) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(view.getComponent()).getFocusOwner();
            view.setEnabled(false);
            JFileChooser fileChooser = view.getExportChooser();
            JSheet.showSheet(fileChooser, view.getComponent(), labels.getString("filechooser.export"), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExportAction.this.exportToFile(view, file, evt.getFileChooser().getFileFilter(), evt.getFileChooser().getAccessory());
                    } else {
                        view.setEnabled(true);
                        if (ExportAction.this.oldFocusOwner != null) {
                            ExportAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        }
    }

    protected void exportToFile(final ExportableView view, final File file, final FileFilter filter, final Component accessory) {
        view.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    view.export(file, filter, accessory);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                ExportAction.this.fileExported(view, file, value);
            }
        });
    }

    protected void fileExported(ExportableView view, File file, Object value) {
        if (value != null) {
            System.out.flush();
            ((Throwable)value).printStackTrace();
            JSheet.showMessageSheet((Component)view.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't export to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        }
        view.setEnabled(true);
        SwingUtilities.getWindowAncestor(view.getComponent()).toFront();
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }
}

