/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class ClearRecentFilesAction
extends AbstractApplicationAction {
    public static final String ID = "file.clearRecentFiles";
    private PropertyChangeListener applicationListener;

    public ClearRecentFilesAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
        this.updateEnabled();
    }

    @Override
    protected void installApplicationListeners(Application app) {
        super.installApplicationListeners(app);
        if (this.applicationListener == null) {
            this.applicationListener = this.createApplicationListener();
        }
        app.addPropertyChangeListener(this.applicationListener);
    }

    private PropertyChangeListener createApplicationListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "recentFiles") {
                    ClearRecentFilesAction.this.updateEnabled();
                }
            }
        };
    }

    @Override
    protected void uninstallApplicationListeners(Application app) {
        super.uninstallApplicationListeners(app);
        app.removePropertyChangeListener(this.applicationListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getApplication().clearRecentFiles();
    }

    private void updateEnabled() {
        this.setEnabled(this.getApplication().recentFiles().size() > 0);
    }
}

