/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class FontProperty
extends PropertyBean
implements PropertyControl {
    String description;
    String label;
    Font font = null;
    private final TextTranslator mTranslator;
    JComboBox mFontComboBox = new JComboBox();
    private String[] mAvailableFontFamilyNames;

    public FontProperty(String description, String label, TextTranslator pTranslator) {
        this.description = description;
        this.label = label;
        this.mTranslator = pTranslator;
        this.mAvailableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.mFontComboBox.setModel(new DefaultComboBoxModel<String>(this.mAvailableFontFamilyNames));
        this.mFontComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                FontProperty.this.firePropertyChangeEvent();
            }
        });
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mFontComboBox);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    @Override
    public void setValue(String pValue) {
        for (int i = 0; i < this.mAvailableFontFamilyNames.length; ++i) {
            String fontName = this.mAvailableFontFamilyNames[i];
            if (!fontName.equals(pValue)) continue;
            this.mFontComboBox.setSelectedIndex(i);
            return;
        }
        System.err.println("Unknown value:" + pValue);
        if (this.mFontComboBox.getModel().getSize() > 0) {
            this.mFontComboBox.setSelectedIndex(0);
        }
    }

    @Override
    public String getValue() {
        return this.mAvailableFontFamilyNames[this.mFontComboBox.getSelectedIndex()];
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mFontComboBox.setEnabled(pEnabled);
    }
}

