/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.stream;

import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;

public class STAXAttributes
implements Attributes {
    private XMLStreamReader reader;

    public STAXAttributes(XMLStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public int getLength() {
        return this.reader.getAttributeCount();
    }

    @Override
    public String getURI(int index) {
        String uri = this.reader.getAttributeNamespace(index);
        return uri == null ? "" : uri;
    }

    @Override
    public String getLocalName(int index) {
        return this.reader.getAttributeLocalName(index);
    }

    @Override
    public String getQName(int index) {
        String localName = this.reader.getAttributeLocalName(index);
        String prefix = this.reader.getAttributePrefix(index);
        return prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
    }

    @Override
    public String getType(int index) {
        return this.reader.getAttributeType(index);
    }

    @Override
    public String getValue(int index) {
        return this.reader.getAttributeValue(index);
    }

    @Override
    public int getIndex(String uri, String localName) {
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.getURI(i).equals(uri) || !this.getLocalName(i).equals(localName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String qname) {
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.getQName(i).equals(qname)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getType(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index == -1 ? null : this.getType(index);
    }

    @Override
    public String getType(String qname) {
        int index = this.getIndex(qname);
        return index == -1 ? null : this.getType(index);
    }

    @Override
    public String getValue(String uri, String localName) {
        return this.reader.getAttributeValue(uri == null ? "" : uri, localName);
    }

    @Override
    public String getValue(String qname) {
        int index = this.getIndex(qname);
        return index == -1 ? null : this.getValue(index);
    }
}

