/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.plaf.UIResource;

public class McWinIcons
extends BaseIcons {
    private static Icon PEARL_RED_24x24 = new LazyImageIcon("mcwin/icons/pearl_red_24x24.png");
    private static Icon PEARL_YELLOW_24x24 = new LazyImageIcon("mcwin/icons/pearl_yellow_24x24.png");
    private static Icon PEARL_GREEN_24x24 = new LazyImageIcon("mcwin/icons/pearl_green_24x24.png");
    private static Icon PEARL_GREY_24x24 = new LazyImageIcon("mcwin/icons/pearl_grey_24x24.png");
    private static Icon PEARL_RED_28x28 = new LazyImageIcon("mcwin/icons/pearl_red_28x28.png");
    private static Icon PEARL_YELLOW_28x28 = new LazyImageIcon("mcwin/icons/pearl_yellow_28x28.png");
    private static Icon PEARL_GREEN_28x28 = new LazyImageIcon("mcwin/icons/pearl_green_28x28.png");
    private static Icon PEARL_GREY_28x28 = new LazyImageIcon("mcwin/icons/pearl_grey_28x28.png");
    private static Icon PEARL_RED_32x32 = new LazyImageIcon("mcwin/icons/pearl_red_32x32.png");
    private static Icon PEARL_YELLOW_32x32 = new LazyImageIcon("mcwin/icons/pearl_yellow_32x32.png");
    private static Icon PEARL_GREEN_32x32 = new LazyImageIcon("mcwin/icons/pearl_green_32x32.png");
    private static Icon PEARL_GREY_32x32 = new LazyImageIcon("mcwin/icons/pearl_grey_32x32.png");
    private static Icon ICONIZER_10x10 = new LazyImageIcon("mcwin/icons/iconizer_10x10.png");
    private static Icon ICONIZER_12x12 = new LazyImageIcon("mcwin/icons/iconizer_12x12.png");
    private static Icon MINIMIZER_10x10 = new LazyImageIcon("mcwin/icons/minimizer_10x10.png");
    private static Icon MINIMIZER_12x12 = new LazyImageIcon("mcwin/icons/minimizer_12x12.png");
    private static Icon MAXIMIZER_10x10 = new LazyImageIcon("mcwin/icons/maximizer_10x10.png");
    private static Icon MAXIMIZER_12x12 = new LazyImageIcon("mcwin/icons/maximizer_12x12.png");
    private static Icon CLOSER_10x10 = new LazyImageIcon("mcwin/icons/closer_10x10.png");
    private static Icon CLOSER_12x12 = new LazyImageIcon("mcwin/icons/closer_12x12.png");
    private static Icon iconIcon = null;
    private static Icon maxIcon = null;
    private static Icon minIcon = null;
    private static Icon closeIcon = null;
    private static Icon radioButtonIcon;
    private static Icon checkBoxIcon;
    private static Icon thumbIcon;
    private static Icon thumbIconRollover;

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new IconIcon();
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new MinIcon();
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new MaxIcon();
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new CloseIcon();
        }
        return closeIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbIcon == null) {
            thumbIcon = new ThumbIcon(false);
        }
        return thumbIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbIcon == null) {
            thumbIcon = new ThumbIcon(false);
        }
        return thumbIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbIconRollover == null) {
            thumbIconRollover = new ThumbIcon(true);
        }
        return thumbIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbIconRollover == null) {
            thumbIconRollover = new ThumbIcon(true);
        }
        return thumbIconRollover;
    }

    static {
        thumbIcon = null;
        thumbIconRollover = null;
    }

    private static class ThumbIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int WIDTH = 15;
        private static final int HEIGHT = 15;
        private boolean isRollover = false;

        public ThumbIcon(boolean bl) {
            this.isRollover = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Object object;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color[] colorArray = null;
            colorArray = this.isRollover ? AbstractLookAndFeel.getTheme().getRolloverColors() : (McWinLookAndFeel.getTheme().isBrightMode() ? AbstractLookAndFeel.getTheme().getButtonColors() : AbstractLookAndFeel.getTheme().getSelectedColors());
            Shape shape = graphics2D.getClip();
            if (shape != null) {
                object = new Area(shape);
                Area area = new Area(new Ellipse2D.Double(n + 1, n2 + 1, 15.0, 15.0));
                area.intersect((Area)object);
                graphics2D.setClip(area);
                JTattooUtilities.fillHorGradient(graphics, colorArray, n + 1, n2 + 1, 15, 15);
                graphics2D.setClip(shape);
            } else {
                object = new Area(new Ellipse2D.Double(n + 1, n2 + 1, 15.0, 15.0));
                graphics2D.setClip((Shape)object);
                JTattooUtilities.fillHorGradient(graphics, colorArray, n, n2, 15, 15);
                graphics2D.setClip(null);
            }
            graphics2D.setColor(AbstractLookAndFeel.getFrameColor());
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawOval(n + 1, n2 + 1, 14, 14);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public int getIconWidth() {
            return 17;
        }

        public int getIconHeight() {
            return 17;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon radioIcon = new LazyImageIcon("mcwin/icons/RadioSymbol.gif");
        private static Icon radioDisabledIcon = new LazyImageIcon("mcwin/icons/RadioSymbolDisabled.gif");
        private static final int WIDTH = 14;
        private static final int HEIGHT = 14;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            Color[] colorArray = null;
            colorArray = jRadioButton.isEnabled() ? (jRadioButton.isRolloverEnabled() && buttonModel.isRollover() && !buttonModel.isArmed() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (!JTattooUtilities.isFrameActive(jRadioButton) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (jRadioButton.isSelected() ? AbstractLookAndFeel.getTheme().getDefaultColors() : AbstractLookAndFeel.getTheme().getButtonColors()))) : AbstractLookAndFeel.getTheme().getDisabledColors();
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            Area area2 = new Area(new Ellipse2D.Double(n, n2, 15.0, 15.0));
            area2.intersect(area);
            graphics2D.setClip(area2);
            JTattooUtilities.fillHorGradient(graphics, colorArray, n, n2, 14, 14);
            graphics2D.setClip(shape);
            if (jRadioButton.isEnabled()) {
                graphics2D.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                graphics2D.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0));
            }
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawOval(n, n2, 14, 14);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            if (buttonModel.isSelected()) {
                int n3 = n + (14 - radioIcon.getIconWidth()) / 2 + 1;
                int n4 = n2 + (14 - radioIcon.getIconHeight()) / 2 + 1;
                if (buttonModel.isEnabled()) {
                    radioIcon.paintIcon(component, graphics, n3, n4);
                } else {
                    radioDisabledIcon.paintIcon(component, graphics, n3, n4);
                }
            }
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon checkIcon = new LazyImageIcon("mcwin/icons/CheckSymbol.gif");
        private static Icon checkDisabledIcon = new LazyImageIcon("mcwin/icons/CheckSymbolDisabled.gif");
        private static Icon checkPressedIcon = new LazyImageIcon("mcwin/icons/CheckPressedSymbol.gif");
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            Color[] colorArray = null;
            if (jCheckBox.isEnabled()) {
                colorArray = jCheckBox.isRolloverEnabled() && buttonModel.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (!JTattooUtilities.isFrameActive(jCheckBox) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (jCheckBox.isSelected() ? AbstractLookAndFeel.getTheme().getDefaultColors() : AbstractLookAndFeel.getTheme().getButtonColors()));
                JTattooUtilities.fillHorGradient(graphics, colorArray, n + 1, n2 + 1, 12, 13);
                graphics.setColor(AbstractLookAndFeel.getFrameColor());
                graphics.drawRect(n, n2, 13, 14);
            } else {
                colorArray = AbstractLookAndFeel.getTheme().getDisabledColors();
                JTattooUtilities.fillHorGradient(graphics, colorArray, n + 1, n2 + 1, 12, 13);
                graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0));
                graphics.drawRect(n, n2, 13, 14);
            }
            if (jCheckBox.isEnabled() && !buttonModel.isRollover() && !buttonModel.isPressed() && !buttonModel.isSelected()) {
                graphics.setColor(Color.white);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 14 - 2);
                graphics.drawLine(n + 13 - 1, n2 + 1, n + 13 - 1, n2 + 14 - 2);
            }
            if (buttonModel.isPressed()) {
                int n3 = n + (13 - checkPressedIcon.getIconWidth()) / 2 + 1;
                int n4 = n2 + (14 - checkPressedIcon.getIconHeight()) / 2 + 1;
                checkPressedIcon.paintIcon(component, graphics, n3, n4);
            } else if (buttonModel.isSelected()) {
                int n5 = n + (13 - checkIcon.getIconWidth()) / 2 + 1;
                int n6 = n2 + (14 - checkIcon.getIconHeight()) / 2;
                if (buttonModel.isEnabled()) {
                    checkIcon.paintIcon(component, graphics, n5 + 2, n6);
                } else {
                    checkDisabledIcon.paintIcon(component, graphics, n5 + 2, n6);
                }
            }
        }

        public int getIconWidth() {
            return 19;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class CloseIcon
    implements Icon,
    UIResource {
        private CloseIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Icon icon = null;
            Icon icon2 = null;
            if (n3 <= 18) {
                icon = CLOSER_10x10;
                icon2 = PEARL_RED_24x24;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_24x24;
                }
            } else if (n3 <= 22) {
                icon = CLOSER_12x12;
                icon2 = PEARL_RED_28x28;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_28x28;
                }
            } else {
                icon = CLOSER_12x12;
                icon2 = PEARL_RED_32x32;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_32x32;
                }
            }
            n = (n3 - icon2.getIconWidth()) / 2;
            n2 = (n4 - icon2.getIconHeight()) / 2;
            icon2.paintIcon(component, graphics, n, n2);
            if (buttonModel.isRollover()) {
                n = (n3 - icon.getIconWidth()) / 2 + n3 % 2;
                n2 = (n4 - icon.getIconHeight()) / 2 + n4 % 2;
                icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }

    private static class MaxIcon
    implements Icon,
    UIResource {
        private MaxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Icon icon = null;
            Icon icon2 = null;
            if (n3 <= 18) {
                icon = MAXIMIZER_10x10;
                icon2 = PEARL_YELLOW_24x24;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_24x24;
                }
            } else if (n3 <= 22) {
                icon = MAXIMIZER_12x12;
                icon2 = PEARL_YELLOW_28x28;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_28x28;
                }
            } else {
                icon = MAXIMIZER_12x12;
                icon2 = PEARL_YELLOW_32x32;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_32x32;
                }
            }
            n = (n3 - icon2.getIconWidth()) / 2;
            n2 = (n4 - icon2.getIconHeight()) / 2;
            icon2.paintIcon(component, graphics, n, n2);
            if (buttonModel.isRollover()) {
                n = (n3 - icon.getIconWidth()) / 2 + n3 % 2;
                n2 = (n4 - icon.getIconHeight()) / 2 + n4 % 2;
                icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }

    private static class MinIcon
    implements Icon,
    UIResource {
        private MinIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Icon icon = null;
            Icon icon2 = null;
            if (n3 <= 18) {
                icon = MINIMIZER_10x10;
                icon2 = PEARL_YELLOW_24x24;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_24x24;
                }
            } else if (n3 <= 22) {
                icon = MINIMIZER_12x12;
                icon2 = PEARL_YELLOW_28x28;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_28x28;
                }
            } else {
                icon = MINIMIZER_12x12;
                icon2 = PEARL_YELLOW_32x32;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_32x32;
                }
            }
            n = (n3 - icon2.getIconWidth()) / 2;
            n2 = (n4 - icon2.getIconHeight()) / 2;
            icon2.paintIcon(component, graphics, n, n2);
            if (buttonModel.isRollover()) {
                n = (n3 - icon.getIconWidth()) / 2 + n3 % 2;
                n2 = (n4 - icon.getIconHeight()) / 2 + n4 % 2;
                icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }

    private static class IconIcon
    implements Icon,
    UIResource {
        private IconIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Icon icon = null;
            Icon icon2 = null;
            if (n3 <= 18) {
                icon = ICONIZER_10x10;
                icon2 = PEARL_GREEN_24x24;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_24x24;
                }
            } else if (n3 <= 22) {
                icon = ICONIZER_12x12;
                icon2 = PEARL_GREEN_28x28;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_28x28;
                }
            } else {
                icon = ICONIZER_12x12;
                icon2 = PEARL_GREEN_32x32;
                if (!JTattooUtilities.isActive(abstractButton)) {
                    icon2 = PEARL_GREY_32x32;
                }
            }
            n = (n3 - icon2.getIconWidth()) / 2;
            n2 = (n4 - icon2.getIconHeight()) / 2;
            icon2.paintIcon(component, graphics, n, n2);
            if (buttonModel.isRollover()) {
                n = (n3 - icon.getIconWidth()) / 2 + n3 % 2;
                n2 = (n4 - icon.getIconHeight()) / 2 + n4 % 2;
                icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }
}

