/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class BaseRadioButtonUI
extends BasicRadioButtonUI {
    private static BaseRadioButtonUI radioButtonUI = null;
    protected static Dimension size = new Dimension();
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        if (radioButtonUI == null) {
            radioButtonUI = new BaseRadioButtonUI();
        }
        return radioButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setRolloverEnabled(true);
        this.icon = UIManager.getIcon("RadioButton.icon");
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        size = abstractButton.getSize(size);
        BaseRadioButtonUI.viewRect.x = insets.left;
        BaseRadioButtonUI.viewRect.y = insets.top;
        BaseRadioButtonUI.viewRect.width = BaseRadioButtonUI.size.width - (insets.right + BaseRadioButtonUI.viewRect.x);
        BaseRadioButtonUI.viewRect.height = BaseRadioButtonUI.size.height - (insets.bottom + BaseRadioButtonUI.viewRect.y);
        BaseRadioButtonUI.iconRect.height = 0;
        BaseRadioButtonUI.iconRect.width = 0;
        BaseRadioButtonUI.iconRect.y = 0;
        BaseRadioButtonUI.iconRect.x = 0;
        BaseRadioButtonUI.textRect.height = 0;
        BaseRadioButtonUI.textRect.width = 0;
        BaseRadioButtonUI.textRect.y = 0;
        BaseRadioButtonUI.textRect.x = 0;
        Icon icon = abstractButton.getIcon();
        int n = this.getDefaultTextIconGap(abstractButton);
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            n = abstractButton.getIconTextGap();
        }
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, n);
        if (jComponent.isOpaque()) {
            this.paintBackground(graphics, jComponent);
        }
        this.paintIcon(graphics, jComponent, iconRect);
        if (string != null) {
            this.paintText(graphics, jComponent, string, textRect);
        }
        if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && BaseRadioButtonUI.textRect.width > 0 && BaseRadioButtonUI.textRect.height > 0) {
            this.paintFocus(graphics, textRect, size);
        }
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = null;
        icon = !buttonModel.isEnabled() ? (abstractButton.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon()) : (buttonModel.isPressed() ? abstractButton.getPressedIcon() : (buttonModel.isRollover() ? (abstractButton.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon()) : (abstractButton.isSelected() ? abstractButton.getSelectedIcon() : abstractButton.getIcon())));
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y - 1);
        } else if (abstractButton.getIcon() != null) {
            abstractButton.getIcon().paintIcon(jComponent, graphics, rectangle.x, rectangle.y - 1);
        } else {
            this.getDefaultIcon().paintIcon(jComponent, graphics, rectangle.x, rectangle.y - 1);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, String string, Rectangle rectangle) {
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            view.paint(graphics, rectangle);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            ButtonModel buttonModel = abstractButton.getModel();
            Font font = jComponent.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = -1;
            n = JTattooUtilities.getJavaVersion() >= 1.4 ? abstractButton.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(abstractButton.getText(), buttonModel.getMnemonic());
            if (buttonModel.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
                graphics.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
    }
}

