/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.mail.internet.MimeUtility;

public class MimeOutputStreamWriter
extends OutputStreamWriter {
    public MimeOutputStreamWriter(OutputStream out) throws UnsupportedEncodingException {
        super(out, "ASCII");
    }

    public void writeHeader(String header, String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.write(header);
            this.write(": ");
            this.write(MimeUtility.encodeText((String)value, (String)"UTF-8", null));
            this.writeLn();
        }
    }

    public void writeHeader(String header, Date value) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss Z", Locale.ENGLISH);
        this.writeHeader(header, formatter.format(value));
    }

    public void writeLn(String line) throws IOException {
        this.write(line);
        this.write("\r\n");
    }

    public void writeLn() throws IOException {
        this.write("\r\n");
    }
}

