/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui.jar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.gui.jar.JarInfoTableCellRend;
import net.sf.portecle.gui.jar.JarInfoTableHeadRend;
import net.sf.portecle.gui.jar.JarInfoTableModel;

public class DJarInfo
extends PortecleJDialog {
    public DJarInfo(Window window) throws IOException {
        super(window, FPortecle.RB.getString("DJarInfo.Title"), true);
        this.initComponents();
    }

    private void initComponents() throws IOException {
        Serializable serializable;
        JarFile[] jarFileArray = this.getClassPathJars();
        JarInfoTableModel jarInfoTableModel = new JarInfoTableModel();
        jarInfoTableModel.load(jarFileArray);
        JTable jTable = new JTable(jarInfoTableModel);
        jTable.setRowMargin(0);
        jTable.getColumnModel().setColumnMargin(0);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setAutoResizeMode(0);
        jTable.getSelectionModel().setSelectionMode(0);
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            serializable = jTable.getColumnModel().getColumn(i);
            ((TableColumn)serializable).setPreferredWidth(150);
            ((TableColumn)serializable).setHeaderRenderer(new JarInfoTableHeadRend());
            ((TableColumn)serializable).setCellRenderer(new JarInfoTableCellRend());
        }
        jTable.setAutoCreateRowSorter(true);
        jTable.getRowSorter().toggleSortOrder(0);
        JScrollPane jScrollPane = new JScrollPane(jTable, 20, 30);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        serializable = new JPanel(new BorderLayout(10, 10));
        ((JComponent)serializable).setPreferredSize(new Dimension(500, 150));
        ((Container)serializable).add(jScrollPane, "Center");
        ((JComponent)serializable).setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton jButton = this.getOkButton(true);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jButton);
        this.getContentPane().add((Component)serializable, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        jButton.requestFocusInWindow();
    }

    private JarFile[] getClassPathJars() throws IOException {
        Attributes attributes;
        String string;
        Object object;
        Object object2;
        ArrayList<JarFile> arrayList = new ArrayList<JarFile>();
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            object = new File((String)object2);
            if (!this.isJarFile((File)object)) continue;
            arrayList.add(new JarFile((File)object));
        }
        if (arrayList.size() == 1 && (object = ((JarFile)(object2 = (JarFile)arrayList.get(0))).getManifest()) != null && (string = (attributes = ((Manifest)object).getMainAttributes()).getValue("Class-Path")) != null) {
            stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                File file = new File(new File(((ZipFile)object2).getName()).getParent(), string4);
                if (!this.isJarFile(file)) continue;
                arrayList.add(new JarFile(file));
            }
        }
        return arrayList.toArray(new JarFile[arrayList.size()]);
    }

    private boolean isJarFile(File file) {
        String string;
        return file.isFile() && ((string = file.getName().toLowerCase()).endsWith(".jar") || string.endsWith(".zip"));
    }
}

