/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.X509Extension;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import net.sf.portecle.DViewCRL;
import net.sf.portecle.DViewCertificate;
import net.sf.portecle.ExtensionsTableCellRend;
import net.sf.portecle.ExtensionsTableHeadRend;
import net.sf.portecle.ExtensionsTableModel;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.OidComparator;
import net.sf.portecle.crypto.X509Ext;
import net.sf.portecle.gui.DesktopUtil;
import net.sf.portecle.gui.error.DThrowable;

class DViewExtensions
extends PortecleJDialog {
    private JTable m_jtExtensions;
    private JEditorPane m_jtaExtensionValue;
    private final X509Extension m_extensions;

    public DViewExtensions(Window window, String string, boolean bl, X509Extension x509Extension) {
        super(window, string, bl);
        this.m_extensions = x509Extension;
        this.initComponents();
    }

    private void initComponents() {
        Object object;
        assert (this.m_extensions.getCriticalExtensionOIDs() != null && !this.m_extensions.getCriticalExtensionOIDs().isEmpty() || this.m_extensions.getNonCriticalExtensionOIDs() != null && !this.m_extensions.getNonCriticalExtensionOIDs().isEmpty());
        ExtensionsTableModel extensionsTableModel = new ExtensionsTableModel();
        this.m_jtExtensions = new JTable(extensionsTableModel);
        this.m_jtExtensions.setShowGrid(false);
        this.m_jtExtensions.setRowMargin(0);
        this.m_jtExtensions.getColumnModel().setColumnMargin(0);
        this.m_jtExtensions.getTableHeader().setReorderingAllowed(false);
        this.m_jtExtensions.setAutoResizeMode(4);
        this.m_jtExtensions.setRowHeight(18);
        for (int i = 0; i < this.m_jtExtensions.getColumnCount(); ++i) {
            object = this.m_jtExtensions.getColumnModel().getColumn(i);
            ((TableColumn)object).setHeaderRenderer(new ExtensionsTableHeadRend());
            ((TableColumn)object).setCellRenderer(new ExtensionsTableCellRend());
        }
        TableColumn tableColumn = this.m_jtExtensions.getColumnModel().getColumn(0);
        tableColumn.setResizable(false);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setPreferredWidth(20);
        object = this.m_jtExtensions.getSelectionModel();
        object.setSelectionMode(0);
        object.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    DViewExtensions.this.updateExtensionValue();
                }
            }
        });
        TableRowSorter<ExtensionsTableModel> tableRowSorter = new TableRowSorter<ExtensionsTableModel>(extensionsTableModel);
        tableRowSorter.setComparator(2, new OidComparator());
        this.m_jtExtensions.setRowSorter(tableRowSorter);
        tableRowSorter.toggleSortOrder(1);
        JScrollPane jScrollPane = new JScrollPane(this.m_jtExtensions, 20, 30);
        jScrollPane.getViewport().setBackground(this.m_jtExtensions.getBackground());
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setPreferredSize(new Dimension(520, 200));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DViewExtensions.jlExtensionValue.text"));
        jPanel2.add((Component)jLabel, "North");
        this.m_jtaExtensionValue = new JEditorPane("text/html", "");
        this.m_jtaExtensionValue.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.m_jtaExtensionValue.setFont(this.m_jtExtensions.getFont());
        this.m_jtaExtensionValue.setEditable(false);
        this.m_jtaExtensionValue.setToolTipText(FPortecle.RB.getString("DViewExtensions.m_jtaExtensionValue.tooltip"));
        jLabel.setLabelFor(this.m_jtaExtensionValue);
        final JEditorPane jEditorPane = this.m_jtaExtensionValue;
        this.m_jtaExtensionValue.addHyperlinkListener(new HyperlinkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    X509Ext.LinkClass linkClass = X509Ext.LinkClass.BROWSER;
                    URL uRL = hyperlinkEvent.getURL();
                    Element element = hyperlinkEvent.getSourceElement();
                    AttributeSet attributeSet = element.getAttributes();
                    if (attributeSet != null && (attributeSet = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A)) != null) {
                        Object object;
                        try {
                            linkClass = X509Ext.LinkClass.valueOf((String)attributeSet.getAttribute(HTML.Attribute.CLASS));
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        if (uRL == null && (object = attributeSet.getAttribute(HTML.Attribute.HREF)) instanceof CharSequence) {
                            try {
                                uRL = new URL(object.toString());
                            }
                            catch (MalformedURLException malformedURLException) {
                                DThrowable.showAndWait(DViewExtensions.this, null, malformedURLException);
                            }
                        }
                    }
                    if (uRL == null) {
                        return;
                    }
                    boolean bl = false;
                    try {
                        jEditorPane.setCursor(Cursor.getPredefinedCursor(3));
                        switch (linkClass) {
                            case CRL: {
                                int n;
                                if (DViewCRL.showAndWait(DViewExtensions.this, uRL) || (n = JOptionPane.showConfirmDialog(DViewExtensions.this, FPortecle.RB.getString("FPortecle.CrlViewFailed.message"), MessageFormat.format(FPortecle.RB.getString("FPortecle.CrlDetails.Title"), uRL), 0)) != 0) break;
                                bl = true;
                                break;
                            }
                            case CERTIFICATE: {
                                int n;
                                if (DViewCertificate.showAndWait(DViewExtensions.this, uRL) || (n = JOptionPane.showConfirmDialog(DViewExtensions.this, FPortecle.RB.getString("FPortecle.CertViewFailed.message"), MessageFormat.format(FPortecle.RB.getString("FPortecle.CertDetails.Title"), uRL), 0)) != 0) break;
                                bl = true;
                                break;
                            }
                            default: {
                                bl = true;
                            }
                        }
                        if (bl) {
                            try {
                                DesktopUtil.browse(DViewExtensions.this, hyperlinkEvent.getURL().toURI());
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                DThrowable.showAndWait(DViewExtensions.this, null, uRISyntaxException);
                            }
                        }
                    }
                    finally {
                        jEditorPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.m_jtaExtensionValue, 20, 30);
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel3.setPreferredSize(new Dimension(520, 200));
        jPanel3.add((Component)jScrollPane2, "Center");
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel4.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        JPanel jPanel5 = new JPanel(new FlowLayout(1));
        JButton jButton = this.getOkButton(true);
        jPanel5.add(jButton);
        extensionsTableModel.load(this.m_extensions);
        if (extensionsTableModel.getRowCount() > 0) {
            this.m_jtExtensions.changeSelection(0, 0, false, false);
        }
        this.getContentPane().add((Component)jPanel4, "Center");
        this.getContentPane().add((Component)jPanel5, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        jButton.requestFocusInWindow();
    }

    private void updateExtensionValue() {
        int n = this.m_jtExtensions.getSelectedRow();
        if (n == -1) {
            this.m_jtaExtensionValue.setText("");
        } else {
            String string = this.m_jtExtensions.getValueAt(n, 2).toString();
            byte[] byArray = this.m_extensions.getExtensionValue(string);
            X509Ext x509Ext = new X509Ext(string, byArray, false);
            try {
                this.m_jtaExtensionValue.setText("<html><head><style type=\"text/css\">ul { list-style-type: none; margin: 0; }\nli ul { margin-left: 10px; }\n</style></head><body>" + x509Ext.getStringValue() + "</body></html>");
            }
            catch (Exception exception) {
                this.m_jtaExtensionValue.setText("");
                DThrowable.showAndWait(this, null, exception);
            }
            this.m_jtaExtensionValue.setCaretPosition(0);
        }
    }
}

