/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.net.InetSocketAddress;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.gui.IntegerDocumentFilter;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.error.DThrowable;

class DGetHostPort
extends PortecleJDialog {
    private static final String DEFAULT_PORT = "443";
    private JTextField m_jtfHost;
    private JTextField m_jtfPort;
    private InetSocketAddress m_iAddress;

    public DGetHostPort(Window window, String string, InetSocketAddress inetSocketAddress) {
        super(window, string, true);
        this.initComponents(inetSocketAddress);
    }

    public InetSocketAddress getHostPort() {
        return this.m_iAddress;
    }

    private void initComponents(InetSocketAddress inetSocketAddress) {
        this.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DGetHostPort.jlHost.text"));
        this.m_jtfHost = new JTextField(15);
        jLabel.setLabelFor(this.m_jtfHost);
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DGetHostPort.jlPort.text"));
        this.m_jtfPort = new JTextField(DEFAULT_PORT, 5);
        Document document = this.m_jtfPort.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new IntegerDocumentFilter(this.m_jtfPort.getColumns()));
        }
        if (inetSocketAddress != null) {
            this.m_jtfHost.setText(inetSocketAddress.getHostName());
            this.m_jtfPort.setText(String.valueOf(inetSocketAddress.getPort()));
        }
        jLabel2.setLabelFor(this.m_jtfPort);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jLabel);
        jPanel.add(this.m_jtfHost);
        jPanel.add(jLabel2);
        jPanel.add(this.m_jtfPort);
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton jButton = this.getOkButton(false);
        JButton jButton2 = this.getCancelButton();
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
    }

    private boolean checkHostPort() {
        int n;
        String string = this.m_jtfHost.getText().trim().toLowerCase(Locale.ENGLISH);
        if (string.isEmpty()) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGetHostPort.HostReq.message"), this.getTitle(), 2);
            SwingHelper.selectAndFocus(this.m_jtfHost);
            return false;
        }
        String string2 = this.m_jtfPort.getText().trim();
        if (string2.isEmpty()) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGetHostPort.PortReq.message"), this.getTitle(), 2);
            SwingHelper.selectAndFocus(this.m_jtfPort);
            return false;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            SwingHelper.selectAndFocus(this.m_jtfPort);
            return false;
        }
        try {
            this.m_iAddress = new InetSocketAddress(string, n);
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            SwingHelper.selectAndFocus(this.m_jtfPort);
            return false;
        }
        return true;
    }

    @Override
    protected void okPressed() {
        if (this.checkHostPort()) {
            super.okPressed();
        }
    }
}

