/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public final class ShowHideLayerAction
extends AbstractAction
implements IEnabledStateUpdating,
Layer.LayerAction,
MultikeyShortcutAction {
    private transient WeakReference<Layer> lastLayer;
    private final transient Shortcut multikeyShortcut;
    private final LayerListDialog.LayerListModel model;

    public ShowHideLayerAction(LayerListDialog.LayerListModel layerListModel) {
        this.model = layerListModel;
        this.putValue("Name", I18n.tr("Show/hide", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "showhide"));
        this.putValue("ShortDescription", I18n.tr("Toggle visible state of the selected layer.", new Object[0]));
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ShowHideLayer"));
        this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:showHideLayer", I18n.tr("Multikey: {0}", I18n.tr("Show/hide layer", new Object[0])), 83, 5005);
        this.multikeyShortcut.setAccelerator(this);
        this.updateEnabledState();
    }

    @Override
    public Shortcut getMultikeyShortcut() {
        return this.multikeyShortcut;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (Layer layer : this.model.getSelectedLayers()) {
            layer.toggleVisible();
        }
    }

    @Override
    public void executeMultikeyAction(int n, boolean bl) {
        Layer layer = LayerListDialog.getLayerForIndex(n);
        if (layer != null) {
            layer.toggleVisible();
            this.lastLayer = new WeakReference<Layer>(layer);
        } else if (bl && this.lastLayer != null && LayerListDialog.isLayerValid(layer = (Layer)this.lastLayer.get())) {
            layer.toggleVisible();
        }
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(!this.model.getSelectedLayers().isEmpty());
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof ShowHideLayerAction;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
        return LayerListDialog.getLayerInfoByClass(Layer.class);
    }

    @Override
    public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
        if (this.lastLayer != null) {
            return LayerListDialog.getLayerInfo((Layer)this.lastLayer.get());
        }
        return null;
    }
}

