/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util.log;

import java.util.Vector;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerListener;
import net.sourceforge.squirrel_sql.fw.util.log.Log4jLogger;
import org.apache.log4j.BasicConfigurator;

public class Log4jLoggerFactory
implements ILoggerFactory {
    private ILoggerListener _listenerOfAllLoggers;
    private Vector<ILoggerListener> _listeners = new Vector();

    public Log4jLoggerFactory() {
        this(true);
    }

    @Override
    public void addLoggerListener(ILoggerListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeLoggerListener(ILoggerListener l) {
        this._listeners.remove(l);
    }

    public Log4jLoggerFactory(boolean doBasicConfig) {
        this._listenerOfAllLoggers = new ILoggerListener(){

            @Override
            public void info(Class<?> source, Object message) {
                try {
                    ILoggerListener[] listeners = Log4jLoggerFactory.this._listeners.toArray(new ILoggerListener[Log4jLoggerFactory.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].info(source, message);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void info(Class<?> source, Object message, Throwable th) {
                try {
                    ILoggerListener[] listeners = Log4jLoggerFactory.this._listeners.toArray(new ILoggerListener[Log4jLoggerFactory.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].info(source, message, th);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void warn(Class<?> source, Object message) {
                try {
                    ILoggerListener[] listeners = Log4jLoggerFactory.this._listeners.toArray(new ILoggerListener[Log4jLoggerFactory.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].warn(source, message);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void warn(Class<?> source, Object message, Throwable th) {
                try {
                    ILoggerListener[] listeners = Log4jLoggerFactory.this._listeners.toArray(new ILoggerListener[Log4jLoggerFactory.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].warn(source, message, th);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void error(Class<?> source, Object message) {
                try {
                    ILoggerListener[] listeners = Log4jLoggerFactory.this._listeners.toArray(new ILoggerListener[Log4jLoggerFactory.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].error(source, message);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void error(Class<?> source, Object message, Throwable th) {
                try {
                    ILoggerListener[] listeners = Log4jLoggerFactory.this._listeners.toArray(new ILoggerListener[Log4jLoggerFactory.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].error(source, message, th);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        if (doBasicConfig) {
            BasicConfigurator.configure();
        }
    }

    @Override
    public ILogger createLogger(Class<?> clazz) {
        return new Log4jLogger(clazz, this._listenerOfAllLoggers);
    }

    @Override
    public void shutdown() {
    }
}

