/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.squirrel.exp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.firebirdsql.squirrel.FirebirdPlugin;

public class DomainParentExpander
implements INodeExpander {
    private static final String SQL = "select cast(rdb$field_name as varchar(31)) as rdb$domain_name from rdb$fields where not (rdb$field_name like 'RDB$%')";
    private static final ILogger s_log = LoggerController.createLogger(DomainParentExpander.class);
    private final FirebirdPlugin _plugin;

    DomainParentExpander(FirebirdPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("FirebirdPlugin == null");
        }
        this._plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSchemaName();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(SQL);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DatabaseObjectInfo si = new DatabaseObjectInfo(catalogName, schemaName, rs.getString(1), DatabaseObjectType.DATATYPE, (ISQLDatabaseMetaData)md);
                childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)si));
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs, (boolean)true);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return childNodes;
    }
}

