/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.preferences.ColorIcon;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;

public class AdjustCaretColorCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AdjustCaretColorCtrl.class);
    private final JCheckBox _chkAdjustCaretColor = new JCheckBox(s_stringMgr.getString("AdjustCaretColorCtrl.adjustCaretColor"));
    private final JLabel _lblCaretColor = new JLabel();
    private final ActionListener _checkBoxListener = e -> this.onAdjustCaretColor();
    private ColorIcon _colorIcon;

    public AdjustCaretColorCtrl() {
        this._chkAdjustCaretColor.addActionListener(this._checkBoxListener);
    }

    public void applyChanges(SyntaxPreferences prefs) {
        prefs.setCaretColorRGB(-1);
        if (this._chkAdjustCaretColor.isSelected()) {
            prefs.setCaretColorRGB(this._colorIcon.getColor().getRGB());
        }
    }

    public void loadData(SyntaxPreferences prefs) {
        this._chkAdjustCaretColor.removeActionListener(this._checkBoxListener);
        this._chkAdjustCaretColor.setSelected(-1 != prefs.getCaretColorRGB());
        this._chkAdjustCaretColor.addActionListener(this._checkBoxListener);
        this.adjustLabel(prefs.getCaretColorRGB());
    }

    private void onAdjustCaretColor() {
        Color color = null;
        if (this._chkAdjustCaretColor.isSelected()) {
            color = JColorChooser.showDialog(this._chkAdjustCaretColor, s_stringMgr.getString("AdjustCaretColorCtrl.color.chooser.title"), null);
        }
        if (null != color) {
            this.adjustLabel(color.getRGB());
        } else {
            this.adjustLabel(-1);
        }
    }

    private void adjustLabel(int caretColorRGB) {
        if (-1 == caretColorRGB) {
            this._lblCaretColor.setBorder(BorderFactory.createEtchedBorder());
            this._colorIcon.setColor(this._chkAdjustCaretColor.getBackground());
        } else {
            this._lblCaretColor.setBorder(BorderFactory.createLineBorder(Color.black));
            this._colorIcon.setColor(new Color(caretColorRGB));
        }
    }

    public void setEnabled(boolean useRSyntaxControl) {
        this._chkAdjustCaretColor.setEnabled(useRSyntaxControl);
    }

    JPanel createCaretColorPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0);
        ret.add((Component)this._chkAdjustCaretColor, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0);
        this._lblCaretColor.setPreferredSize(new Dimension(16, 16));
        this._colorIcon = new ColorIcon(14, 14);
        this._colorIcon.setBorderColor(null);
        this._lblCaretColor.setIcon((Icon)this._colorIcon);
        ret.add((Component)this._lblCaretColor, gbc);
        return ret;
    }
}

